/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import java.math.BigDecimal;
import org.opendaylight.yangtools.yang.xpath.api.AbstractYangXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.BigDecimalNumberExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangBinaryOperator;
import org.opendaylight.yangtools.yang.xpath.api.YangBooleanConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

final class BigDecimalXPathMathSupport
extends AbstractYangXPathMathSupport<BigDecimalNumberExpr> {
    static final BigDecimalXPathMathSupport INSTANCE = new BigDecimalXPathMathSupport();
    private static final long serialVersionUID = 1L;
    private static final BigDecimalNumberExpr ZERO = BigDecimalNumberExpr.of(BigDecimal.ZERO);
    private static final BigDecimalNumberExpr ONE = BigDecimalNumberExpr.of(BigDecimal.ONE);
    private static final BigDecimalNumberExpr TEN = BigDecimalNumberExpr.of(BigDecimal.TEN);

    private BigDecimalXPathMathSupport() {
        super(BigDecimalNumberExpr.class);
    }

    @Override
    public BigDecimalNumberExpr createNumber(String str) {
        switch (str) {
            case "0": {
                return ZERO;
            }
            case "1": {
                return ONE;
            }
            case "10": {
                return TEN;
            }
        }
        return BigDecimalNumberExpr.of(new BigDecimal(str));
    }

    @Override
    public BigDecimalNumberExpr createNumber(int value) {
        switch (value) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 10: {
                return TEN;
            }
        }
        return BigDecimalNumberExpr.of(BigDecimal.valueOf(value));
    }

    @Override
    protected BigDecimalNumberExpr doNegateNumber(BigDecimalNumberExpr number) {
        return BigDecimalNumberExpr.of(number.getNumber().negate());
    }

    @Override
    protected YangExpr doEvaluate(YangBinaryOperator operator, BigDecimalNumberExpr left, BigDecimalNumberExpr right) {
        BigDecimal result;
        BigDecimal l = left.getNumber();
        BigDecimal r = right.getNumber();
        switch (operator) {
            case DIV: {
                result = l.divide(r);
                break;
            }
            case EQUALS: {
                return YangBooleanConstantExpr.of(l.equals(r));
            }
            case GT: {
                return YangBooleanConstantExpr.of(l.compareTo(r) > 0);
            }
            case GTE: {
                return YangBooleanConstantExpr.of(l.compareTo(r) >= 0);
            }
            case LT: {
                return YangBooleanConstantExpr.of(l.compareTo(r) < 0);
            }
            case LTE: {
                return YangBooleanConstantExpr.of(l.compareTo(r) <= 0);
            }
            case MINUS: {
                result = l.subtract(r);
                break;
            }
            case MOD: {
                result = l.remainder(r);
                break;
            }
            case MUL: {
                result = l.multiply(r);
                break;
            }
            case NOT_EQUALS: {
                return YangBooleanConstantExpr.of(!l.equals(r));
            }
            case PLUS: {
                result = l.add(r);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled operator " + operator);
            }
        }
        return BigDecimalNumberExpr.of(result);
    }

    @Override
    protected Object readResolve() {
        return INSTANCE;
    }
}

