/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.xpath.api.YangConstantExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangFunction;
import org.opendaylight.yangtools.yang.xpath.api.YangFunctionCallExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;

@Beta
public enum YangBooleanConstantExpr implements YangConstantExpr<Boolean>
{
    FALSE(Boolean.FALSE, YangFunction.FALSE, "false"),
    TRUE(Boolean.TRUE, YangFunction.TRUE, "true");

    private final YangFunctionCallExpr function;
    private final YangLiteralExpr literal;
    private final Boolean value;

    private YangBooleanConstantExpr(Boolean value, YangFunction function, String literal) {
        this.value = Objects.requireNonNull(value);
        this.function = YangFunctionCallExpr.of(function.getIdentifier());
        this.literal = YangLiteralExpr.of(literal);
    }

    @Override
    public QName getIdentifier() {
        return this.function.getName();
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    public YangFunctionCallExpr asFunction() {
        return this.function;
    }

    public YangLiteralExpr asStringLiteral() {
        return this.literal;
    }

    public static YangBooleanConstantExpr of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static Optional<YangFunctionCallExpr> forFunctionName(String functionName) {
        switch (functionName) {
            case "false": {
                return Optional.of(YangBooleanConstantExpr.FALSE.function);
            }
            case "true": {
                return Optional.of(YangBooleanConstantExpr.TRUE.function);
            }
        }
        return Optional.empty();
    }
}

