/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.common.YangVersion;

@Beta
public enum YangFunction implements Identifiable<QName>
{
    BOOLEAN("boolean"),
    CEILING("ceiling"),
    CONCAT("concat"),
    CONTAINS("contains"),
    COUNT("count"),
    FALSE("false"),
    FLOOR("floor"),
    ID("id"),
    LANG("lang"),
    LAST("last"),
    LOCAL_NAME("local-name"),
    NAME("name"),
    NUMBER("number"),
    NAMESPACE_URI("namespace-uri"),
    NORMALIZE_SPACE("normalize-space"),
    NOT("not"),
    POSITION("position"),
    ROUND("round"),
    STARTS_WITH("starts-with"),
    STRING("string"),
    STRING_LENGTH("string-length"),
    SUM("sum"),
    SUBSTRING("substring"),
    SUBSTRING_AFTER("substring-after"),
    SUBSTRING_BEFORE("substring-before"),
    TRANSLATE("translate"),
    TRUE("true"),
    CURRENT("current"),
    BIT_IS_SET("bit-is-set", YangVersion.VERSION_1_1),
    DEREF("deref", YangVersion.VERSION_1_1),
    DERIVED_FROM("derived-from", YangVersion.VERSION_1_1),
    DERIVED_FROM_OR_SELF("derived-from-or-self", YangVersion.VERSION_1_1),
    ENUM_VALUE("enum-value", YangVersion.VERSION_1_1),
    RE_MATCH("re-match", YangVersion.VERSION_1_1);

    private final QName identifier;
    private final YangVersion yangVersion;

    private YangFunction(String localName, YangVersion yangVersion) {
        this.identifier = QName.create(YangConstants.RFC6020_YIN_MODULE, localName).intern();
        this.yangVersion = Objects.requireNonNull(yangVersion);
    }

    private YangFunction(String localName) {
        this(localName, YangVersion.VERSION_1);
    }

    @Override
    public QName getIdentifier() {
        return this.identifier;
    }

    public YangVersion getYangVersion() {
        return this.yangVersion;
    }
}

