/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangLocationPath;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathNodeType;

@Beta
public enum YangXPathAxis {
    CHILD("child"),
    DESCENDANT("descendant"),
    PARENT("parent"),
    ANCESTOR("ancestor"),
    FOLLOWING_SIBLING("following-sibling"),
    PRECEDING_SIBLING("preceding-sibling"),
    FOLLOWING("following"),
    PRECEDING("preceding"),
    ATTRIBUTE("attribute"),
    NAMESPACE("namespace"),
    SELF("self"),
    DESCENDANT_OR_SELF("descendant-or-self"),
    ANCESTOR_OR_SELF("ancestor-or-self");

    private final YangLocationPath.AxisStep step = new YangLocationPath.AxisStep(this);
    private final String str;

    private YangXPathAxis(String str) {
        this.str = Objects.requireNonNull(str);
    }

    public final YangLocationPath.AxisStep asStep() {
        return this.step;
    }

    public final YangLocationPath.AxisStep asStep(Collection<YangExpr> predicates) {
        return predicates.isEmpty() ? this.step : new YangLocationPath.AxisStepWithPredicates(this, ImmutableSet.copyOf(predicates));
    }

    public final YangLocationPath.ResolvedQNameStep asStep(QName qname) {
        return new YangLocationPath.ResolvedQNameStep(this, qname);
    }

    public final YangLocationPath.ResolvedQNameStep asStep(QName qname, Collection<YangExpr> predicates) {
        return YangLocationPath.ResolvedQNameStep.of(this, qname, predicates);
    }

    public final YangLocationPath.UnresolvedQNameStep asStep(AbstractQName qname) {
        return new YangLocationPath.UnresolvedQNameStep(this, qname);
    }

    public final YangLocationPath.UnresolvedQNameStep asStep(AbstractQName qname, Collection<YangExpr> predicates) {
        return YangLocationPath.UnresolvedQNameStep.of(this, qname, predicates);
    }

    public final YangLocationPath.NodeTypeStep asStep(YangXPathNodeType type) {
        return new YangLocationPath.NodeTypeStep(this, type);
    }

    public final YangLocationPath.NodeTypeStep asStep(YangXPathNodeType type, Collection<YangExpr> predicates) {
        return predicates.isEmpty() ? this.asStep(type) : new YangLocationPath.NodeTypeStepWithPredicates(this, type, ImmutableSet.copyOf(predicates));
    }

    public final YangLocationPath.ProcessingInstructionStep asStep(String name) {
        return new YangLocationPath.ProcessingInstructionStep(this, name);
    }

    public final YangLocationPath.ProcessingInstructionStep asStep(String name, Collection<YangExpr> predicates) {
        return predicates.isEmpty() ? this.asStep(name) : new YangLocationPath.ProcessingInstructionStepWithPredicates(this, name, ImmutableSet.copyOf(predicates));
    }

    public String toString() {
        return this.str;
    }
}

