/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import tech.pantheon.triemap.BasicNode;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.FailedNode;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.LNode;
import tech.pantheon.triemap.LNodeEntry;
import tech.pantheon.triemap.LookupResult;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.SNode;
import tech.pantheon.triemap.TNode;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

final class INode<K, V>
extends BasicNode {
    private static final AtomicReferenceFieldUpdater<INode, MainNode> MAINNODE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(INode.class, MainNode.class, "mainnode");
    private final Gen gen;
    private volatile MainNode<K, V> mainnode;

    INode(Gen gen, MainNode<K, V> mainnode) {
        this.gen = gen;
        this.mainnode = mainnode;
    }

    MainNode<K, V> gcasRead(TrieMap<?, ?> ct) {
        MainNode<K, V> main = this.mainnode;
        MainNode<K, V> prevval = main.readPrev();
        if (prevval == null) {
            return main;
        }
        return this.gcasComplete(main, ct);
    }

    private MainNode<K, V> gcasComplete(MainNode<K, V> oldmain, TrieMap<?, ?> ct) {
        MainNode<K, V> main = oldmain;
        while (main != null) {
            MainNode<K, V> prev = main.readPrev();
            INode<?, ?> ctr = ct.readRoot(true);
            if (prev == null) {
                return main;
            }
            if (prev instanceof FailedNode) {
                FailedNode fn = (FailedNode)prev;
                if (MAINNODE_UPDATER.compareAndSet(this, main, fn.readPrev())) {
                    return fn.readPrev();
                }
                main = this.mainnode;
                continue;
            }
            if (ctr.gen == this.gen && !ct.isReadOnly()) {
                if (!main.casPrev(prev, null)) continue;
                return main;
            }
            main.casPrev(prev, new FailedNode<K, V>(prev));
            main = this.mainnode;
        }
        return null;
    }

    private boolean gcas(MainNode<K, V> oldMain, MainNode<K, V> newMain, TrieMap<?, ?> ct) {
        newMain.writePrev(oldMain);
        if (MAINNODE_UPDATER.compareAndSet(this, oldMain, newMain)) {
            this.gcasComplete(newMain, ct);
            return newMain.readPrev() == null;
        }
        return false;
    }

    private INode<K, V> inode(MainNode<K, V> cn) {
        return new INode<K, V>(this.gen, cn);
    }

    INode<K, V> copyToGen(Gen ngen, TrieMap<?, ?> ct) {
        return new INode<K, V>(ngen, this.gcasRead(ct));
    }

    boolean recInsert(K key, V value, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recInsert(key, value, hc, lev, parent, this.gen, ct);
    }

    private boolean recInsert(K key, V val, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m3;
        while ((m3 = this.gcasRead(ct)) instanceof CNode) {
            CNode<K, V> cn = (CNode<K, V>)m3;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            int bmp = cn.bitmap;
            int mask = flag - 1;
            int pos = Integer.bitCount(bmp & mask);
            if ((bmp & flag) != 0) {
                BasicNode cnAtPos = cn.array[pos];
                if (cnAtPos instanceof INode) {
                    INode in = (INode)cnAtPos;
                    if (startgen == in.gen) {
                        return in.recInsert(key, val, hc, lev + 5, this, startgen, ct);
                    }
                    if (this.gcas(cn, cn.renewed(startgen, ct), ct)) continue;
                    return false;
                }
                if (cnAtPos instanceof SNode) {
                    SNode sn = (SNode)cnAtPos;
                    if (sn.hc == hc && ct.equal(sn.key, key)) {
                        return this.gcas(cn, cn.updatedAt(pos, new SNode<K, V>(key, val, hc), this.gen), ct);
                    }
                    CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
                    CNode<K, V> nn = rn.updatedAt(pos, this.inode(CNode.dual(sn, key, val, hc, lev + 5, this.gen)), this.gen);
                    return this.gcas(cn, nn, ct);
                }
                throw CNode.invalidElement(cnAtPos);
            }
            CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
            CNode<K, V> ncnode = rn.insertedAt(pos, flag, new SNode<K, V>(key, val, hc), this.gen);
            return this.gcas(cn, ncnode, ct);
        }
        if (m3 instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return false;
        }
        if (m3 instanceof LNode) {
            LNode ln = (LNode)m3;
            LNodeEntry entry = ln.get(ct.equiv(), key);
            return entry != null ? this.replaceln(ln, entry, val, ct) : this.insertln(ln, key, val, ct);
        }
        throw INode.invalidElement(m3);
    }

    static VerifyException invalidElement(BasicNode elem) {
        throw new VerifyException("An INode can host only a CNode, a TNode or an LNode, not " + elem);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> insertDual(TrieMap<K, V> ct, CNode<K, V> cn, int pos, SNode<K, V> sn, K key, V val, int hc, int lev) {
        CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
        CNode<K, V> nn = rn.updatedAt(pos, this.inode(CNode.dual(sn, key, val, hc, lev + 5, this.gen)), this.gen);
        return this.gcas(cn, nn, ct) ? Optional.empty() : null;
    }

    Optional<V> recInsertIf(K key, V val, int hc, Object cond, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recInsertIf(key, val, hc, cond, lev, parent, this.gen, ct);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> recInsertIf(K key, V val, int hc, Object cond, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m3;
        while ((m3 = this.gcasRead(ct)) instanceof CNode) {
            CNode<K, V> cn = (CNode<K, V>)m3;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            int bmp = cn.bitmap;
            int mask = flag - 1;
            int pos = Integer.bitCount(bmp & mask);
            if ((bmp & flag) != 0) {
                BasicNode cnAtPos = cn.array[pos];
                if (cnAtPos instanceof INode) {
                    INode in = (INode)cnAtPos;
                    if (startgen == in.gen) {
                        return in.recInsertIf(key, val, hc, cond, lev + 5, this, startgen, ct);
                    }
                    if (this.gcas(cn, cn.renewed(startgen, ct), ct)) continue;
                    return null;
                }
                if (cnAtPos instanceof SNode) {
                    SNode sn = (SNode)cnAtPos;
                    if (cond == null) {
                        if (sn.hc == hc && ct.equal(sn.key, key)) {
                            if (this.gcas(cn, cn.updatedAt(pos, new SNode<K, V>(key, val, hc), this.gen), ct)) {
                                return Optional.of(sn.value);
                            }
                            return null;
                        }
                        return this.insertDual(ct, cn, pos, sn, key, val, hc, lev);
                    }
                    if (cond == PresencePredicate.ABSENT) {
                        if (sn.hc == hc && ct.equal(sn.key, key)) {
                            return Optional.of(sn.value);
                        }
                        return this.insertDual(ct, cn, pos, sn, key, val, hc, lev);
                    }
                    if (cond == PresencePredicate.PRESENT) {
                        if (sn.hc == hc && ct.equal(sn.key, key)) {
                            if (this.gcas(cn, cn.updatedAt(pos, new SNode<K, V>(key, val, hc), this.gen), ct)) {
                                return Optional.of(sn.value);
                            }
                            return null;
                        }
                        return Optional.empty();
                    }
                    if (sn.hc == hc && ct.equal(sn.key, key) && cond.equals(sn.value)) {
                        if (this.gcas(cn, cn.updatedAt(pos, new SNode<K, V>(key, val, hc), this.gen), ct)) {
                            return Optional.of(sn.value);
                        }
                        return null;
                    }
                    return Optional.empty();
                }
                throw CNode.invalidElement(cnAtPos);
            }
            if (cond == null || cond == PresencePredicate.ABSENT) {
                CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
                CNode<K, V> ncnode = rn.insertedAt(pos, flag, new SNode<K, V>(key, val, hc), this.gen);
                if (this.gcas(cn, ncnode, ct)) {
                    return Optional.empty();
                }
                return null;
            }
            return Optional.empty();
        }
        if (m3 instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return null;
        }
        if (m3 instanceof LNode) {
            LNode ln = (LNode)m3;
            LNodeEntry entry = ln.get(ct.equiv(), key);
            if (cond == null) {
                if (entry != null) {
                    return this.replaceln(ln, entry, val, ct) ? Optional.of(entry.getValue()) : null;
                }
                return this.insertln(ln, key, val, ct) ? Optional.empty() : null;
            }
            if (cond == PresencePredicate.ABSENT) {
                if (entry != null) {
                    return Optional.of(entry.getValue());
                }
                return this.insertln(ln, key, val, ct) ? Optional.empty() : null;
            }
            if (cond == PresencePredicate.PRESENT) {
                if (entry == null) {
                    return Optional.empty();
                }
                return this.replaceln(ln, entry, val, ct) ? Optional.of(entry.getValue()) : null;
            }
            if (entry == null || !cond.equals(entry.getValue())) {
                return Optional.empty();
            }
            return this.replaceln(ln, entry, val, ct) ? Optional.of(entry.getValue()) : null;
        }
        throw INode.invalidElement(m3);
    }

    private boolean insertln(LNode<K, V> ln, K key, V val, TrieMap<K, V> ct) {
        return this.gcas(ln, ln.insertChild(key, val), ct);
    }

    private boolean replaceln(LNode<K, V> ln, LNodeEntry<K, V> entry, V val, TrieMap<K, V> ct) {
        return this.gcas(ln, ln.replaceChild(entry, val), ct);
    }

    Object recLookup(K key, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recLookup(key, hc, lev, parent, this.gen, ct);
    }

    private Object recLookup(K key, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m3;
        while ((m3 = this.gcasRead(ct)) instanceof CNode) {
            CNode cn = (CNode)m3;
            int bmp = cn.bitmap;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            if ((bmp & flag) == 0) {
                return null;
            }
            int pos = bmp == -1 ? idx : Integer.bitCount(bmp & flag - 1);
            BasicNode sub = cn.array[pos];
            if (sub instanceof INode) {
                INode in = (INode)sub;
                if (ct.isReadOnly() || startgen == in.gen) {
                    return in.recLookup(key, hc, lev + 5, this, startgen, ct);
                }
                if (this.gcas(cn, cn.renewed(startgen, ct), ct)) continue;
                return LookupResult.RESTART;
            }
            if (sub instanceof SNode) {
                SNode sn = (SNode)sub;
                if (sn.hc == hc && ct.equal(sn.key, key)) {
                    return sn.value;
                }
                return null;
            }
            throw CNode.invalidElement(sub);
        }
        if (m3 instanceof TNode) {
            return this.cleanReadOnly((TNode)m3, lev, parent, ct, key, hc);
        }
        if (m3 instanceof LNode) {
            LNodeEntry entry = ((LNode)m3).get(ct.equiv(), key);
            return entry != null ? entry.getValue() : null;
        }
        throw INode.invalidElement(m3);
    }

    private Object cleanReadOnly(TNode<K, V> tn, int lev, INode<K, V> parent, TrieMap<K, V> ct, K key, int hc) {
        if (ct.isReadOnly()) {
            if (tn.hc == hc && ct.equal(tn.key, key)) {
                return tn.value;
            }
            return null;
        }
        this.clean(parent, ct, lev - 5);
        return LookupResult.RESTART;
    }

    Optional<V> recRemove(K key, Object cond, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recRemove(key, cond, hc, lev, parent, this.gen, ct);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> recRemove(K key, Object cond, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m3 = this.gcasRead(ct);
        if (m3 instanceof CNode) {
            MainNode<K, V> n;
            Optional<Object> res;
            CNode cn = (CNode)m3;
            int bmp = cn.bitmap;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            if ((bmp & flag) == 0) {
                return Optional.empty();
            }
            int pos = Integer.bitCount(bmp & flag - 1);
            BasicNode sub = cn.array[pos];
            if (sub instanceof INode) {
                INode in = (INode)sub;
                res = startgen == in.gen ? in.recRemove(key, cond, hc, lev + 5, this, startgen, ct) : (this.gcas(cn, cn.renewed(startgen, ct), ct) ? this.recRemove(key, cond, hc, lev, parent, startgen, ct) : null);
            } else if (sub instanceof SNode) {
                MainNode ncn;
                SNode sn = (SNode)sub;
                res = sn.hc == hc && ct.equal(sn.key, key) && (cond == null || cond.equals(sn.value)) ? (this.gcas(cn, ncn = cn.removedAt(pos, flag, this.gen).toContracted(lev), ct) ? Optional.of(sn.value) : null) : Optional.empty();
            } else {
                throw CNode.invalidElement(sub);
            }
            if (res == null || !res.isPresent()) {
                return res;
            }
            if (parent != null && (n = this.gcasRead(ct)) instanceof TNode) {
                this.cleanParent(n, parent, ct, hc, lev, startgen);
            }
            return res;
        }
        if (m3 instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return null;
        }
        if (m3 instanceof LNode) {
            LNode ln = (LNode)m3;
            LNodeEntry entry = ln.get(ct.equiv(), key);
            if (entry == null) {
                return Optional.empty();
            }
            Object value = entry.getValue();
            if (cond != null && !cond.equals(value)) {
                return Optional.empty();
            }
            return this.gcas(ln, ln.removeChild(entry, hc), ct) ? Optional.of(value) : null;
        }
        throw INode.invalidElement(m3);
    }

    private void cleanParent(Object nonlive, INode<K, V> parent, TrieMap<K, V> ct, int hc, int lev, Gen startgen) {
        TNode tn;
        MainNode ncn;
        int flag;
        int bmp;
        int pos;
        CNode cn;
        BasicNode sub;
        do {
            MainNode<K, V> pm;
            if (!((pm = parent.gcasRead(ct)) instanceof CNode)) {
                return;
            }
            cn = (CNode)pm;
            bmp = cn.bitmap;
            int idx = hc >>> lev - 5 & 0x1F;
            flag = 1 << idx;
            if ((bmp & flag) != 0) continue;
            return;
        } while ((sub = cn.array[pos = Integer.bitCount(bmp & flag - 1)]) == this && nonlive instanceof TNode && !super.gcas(cn, ncn = cn.updatedAt(pos, (tn = (TNode)nonlive).copyUntombed(), this.gen).toContracted(lev - 5), ct) && ct.readRoot().gen == startgen);
    }

    private void clean(INode<K, V> nd, TrieMap<K, V> ct, int lev) {
        MainNode<K, V> m3 = nd.gcasRead(ct);
        if (m3 instanceof CNode) {
            CNode cn = (CNode)m3;
            super.gcas(cn, cn.toCompressed(ct, lev, this.gen), ct);
        }
    }

    int size(ImmutableTrieMap<?, ?> ct) {
        return this.gcasRead(ct).size(ct);
    }
}

