/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import tech.pantheon.triemap.Equivalence;
import tech.pantheon.triemap.LNodeEntry;
import tech.pantheon.triemap.VerifyException;

abstract class LNodeEntries<K, V>
extends LNodeEntry<K, V> {
    LNodeEntries(K key, V value) {
        super(key, value);
    }

    static <K, V> LNodeEntries<K, V> map(K k1, V v1, K k2, V v2) {
        return new Multiple<K, V>(k1, v1, new Single<K, V>(k2, v2));
    }

    abstract LNodeEntries<K, V> next();

    final LNodeEntry<K, V> findEntry(Equivalence<? super K> equiv, K key) {
        LNodeEntries<K, V> entry = this;
        do {
            if (!equiv.equivalent(entry.getKey(), key)) continue;
            return entry;
        } while ((entry = entry.next()) != null);
        return null;
    }

    final LNodeEntries<K, V> insert(K key, V value) {
        return new Multiple<K, V>(key, value, this);
    }

    final LNodeEntries<K, V> replace(LNodeEntry<K, V> entry, V value) {
        LNodeEntries<K, V> removed = this.remove(entry);
        return removed == null ? new Single<K, V>(entry.getKey(), value) : new Multiple<K, V>(entry.getKey(), value, removed);
    }

    final LNodeEntries<K, V> remove(LNodeEntry<K, V> entry) {
        Multiple ret;
        if (entry == this) {
            return this.next();
        }
        Multiple last = ret = new Multiple(this);
        for (LNodeEntries<K, V> cur = this.next(); cur != null; cur = cur.next()) {
            if (entry == cur) {
                last.next = cur.next();
                return ret;
            }
            Multiple<K, V> tmp = new Multiple<K, V>(cur);
            last.next = tmp;
            last = tmp;
        }
        throw new VerifyException("Failed to find entry " + entry);
    }

    private static final class Multiple<K, V>
    extends LNodeEntries<K, V> {
        LNodeEntries<K, V> next;

        Multiple(LNodeEntries<K, V> entry) {
            this(entry.getKey(), entry.getValue(), null);
        }

        Multiple(K key, V value, LNodeEntries<K, V> next) {
            super(key, value);
            this.next = next;
        }

        @Override
        LNodeEntries<K, V> next() {
            return this.next;
        }
    }

    static final class Single<K, V>
    extends LNodeEntries<K, V> {
        Single(K key, V value) {
            super(key, value);
        }

        @Override
        LNodeEntries<K, V> next() {
            return null;
        }
    }
}

