/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.api;

import org.opendaylight.yangtools.concepts.Identifier;

public class ModuleIdentifier
implements Identifier {
    private static final long serialVersionUID = 1L;
    private final String factoryName;
    private final String instanceName;

    public ModuleIdentifier(String factoryName, String instanceName) {
        if (factoryName == null) {
            throw new IllegalArgumentException("Parameter 'factoryName' is null");
        }
        if (instanceName == null) {
            throw new IllegalArgumentException("Parameter 'instanceName' is null");
        }
        this.factoryName = factoryName;
        this.instanceName = instanceName;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ModuleIdentifier that = (ModuleIdentifier)object;
        if (!this.factoryName.equals(that.factoryName)) {
            return false;
        }
        return this.instanceName.equals(that.instanceName);
    }

    @Override
    public int hashCode() {
        int result = this.factoryName.hashCode();
        result = 31 * result + this.instanceName.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ModuleIdentifier{factoryName='" + this.factoryName + '\'' + ", instanceName='" + this.instanceName + '\'' + '}';
    }
}

