/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.ietf.stateful07;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.parser.message.PCEPErrorMessageParser;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcerr.pcerr.message.error.type.StatefulCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcerr.pcerr.message.error.type.StatefulCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcerr.pcerr.message.error.type.stateful._case.StatefulBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcerr.pcerr.message.error.type.stateful._case.stateful.Srps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcerr.pcerr.message.error.type.stateful._case.stateful.SrpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.srp.object.Srp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.SessionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.session._case.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;

public final class Stateful07ErrorMessageParser
extends PCEPErrorMessageParser {
    public Stateful07ErrorMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected void serializeCases(PcerrMessage err, ByteBuf buffer) {
        if (err.getErrorType() instanceof RequestCase) {
            List<Rps> rps = ((RequestCase)err.getErrorType()).getRequest().getRps();
            for (Rps r : rps) {
                this.serializeObject(r.getRp(), buffer);
            }
        }
        if (err.getErrorType() instanceof StatefulCase) {
            List<Srps> srps = ((StatefulCase)err.getErrorType()).getStateful().getSrps();
            for (Srps s : srps) {
                this.serializeObject(s.getSrp(), buffer);
            }
        }
    }

    @Override
    protected org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PcerrMessage validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Object o;
        Preconditions.checkArgument(objects != null, "Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Error message is empty.");
        }
        ArrayList<Rps> requestParameters = new ArrayList<Rps>();
        ArrayList<Srps> srps = new ArrayList<Srps>();
        ArrayList<Errors> errorObjects = new ArrayList<Errors>();
        PcerrMessageBuilder b = new PcerrMessageBuilder();
        Object obj = objects.get(0);
        State state = State.INIT;
        if (obj instanceof ErrorObject) {
            o = (ErrorObject)obj;
            errorObjects.add(new ErrorsBuilder().setErrorObject((ErrorObject)o).build());
            state = State.ERROR_IN;
        } else if (obj instanceof Rp) {
            o = (Rp)obj;
            if (o.isProcessingRule().booleanValue()) {
                errors.add(Stateful07ErrorMessageParser.createErrorMsg(PCEPErrors.P_FLAG_NOT_SET, Optional.absent()));
                return null;
            }
            requestParameters.add(new RpsBuilder().setRp((Rp)o).build());
            state = State.RP_IN;
        } else if (obj instanceof Srp) {
            Srp s = (Srp)obj;
            srps.add(new SrpsBuilder().setSrp(s).build());
            state = State.SRP_IN;
        }
        if (!state.equals((java.lang.Object)State.INIT)) {
            objects.remove(0);
        }
        while (!objects.isEmpty() && !state.equals((java.lang.Object)State.END)) {
            obj = objects.get(0);
            if (obj instanceof UnknownObject) {
                return new PcerrBuilder().setPcerrMessage(b.setErrors(((UnknownObject)obj).getErrors()).build()).build();
            }
            if ((state = Stateful07ErrorMessageParser.insertObject(state, obj, errorObjects, requestParameters, srps, b)).equals((java.lang.Object)State.END)) continue;
            objects.remove(0);
        }
        if (errorObjects.isEmpty()) {
            throw new PCEPDeserializerException("At least one PCEPErrorObject is mandatory.");
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        if (!requestParameters.isEmpty()) {
            b.setErrorType(new RequestCaseBuilder().setRequest(new RequestBuilder().setRps(requestParameters).build()).build());
        }
        if (!srps.isEmpty()) {
            b.setErrorType(new StatefulCaseBuilder().setStateful(new StatefulBuilder().setSrps(srps).build()).build());
        }
        return new PcerrBuilder().setPcerrMessage(b.setErrors(errorObjects).build()).build();
    }

    private static State insertObject(State state, Object obj, List<Errors> errorObjects, List<Rps> requestParameters, List<Srps> srps, PcerrMessageBuilder b) {
        switch (state) {
            case ERROR_IN: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR_IN;
                }
            }
            case RP_IN: {
                if (obj instanceof Rp) {
                    Rp o = (Rp)obj;
                    requestParameters.add(new RpsBuilder().setRp(o).build());
                    return State.RP_IN;
                }
            }
            case SRP_IN: {
                if (obj instanceof Srp) {
                    Srp o = (Srp)obj;
                    srps.add(new SrpsBuilder().setSrp(o).build());
                    return State.SRP_IN;
                }
            }
            case OPEN: {
                if (obj instanceof Open) {
                    b.setErrorType(new SessionCaseBuilder().setSession(new SessionBuilder().setOpen((Open)obj).build()).build());
                    return State.OPEN_IN;
                }
            }
            case ERROR: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR;
                }
            }
            case OPEN_IN: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        ERROR_IN,
        RP_IN,
        SRP_IN,
        OPEN,
        ERROR,
        OPEN_IN,
        END;

    }
}

