/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.Ipv6Case;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.Ipv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case.Ipv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.address.family.ipv6._case.Ipv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObjBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPEndPointsIpv6ObjectParser
implements ObjectParser {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPEndPointsIpv6ObjectParser.class);
    public static final int CLASS = 4;
    public static final int TYPE = 2;

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        if (!header.isProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on Endpoints OBJECT, ignoring it.");
            return new UnknownObject(PCEPErrors.P_FLAG_NOT_SET, builder.build());
        }
        if (bytes.readableBytes() != 32) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        Ipv6Builder b = new Ipv6Builder();
        b.setSourceIpv6Address(Ipv6Util.addressForByteBuf(bytes));
        b.setDestinationIpv6Address(Ipv6Util.addressForByteBuf(bytes));
        builder.setAddressFamily(new Ipv6CaseBuilder().setIpv6(b.build()).build());
        return builder.build();
    }

    public static void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof EndpointsObj, "Wrong instance of PCEPObject. Passed %s. Needed EndpointsObject.", object.getClass());
        EndpointsObj ePObj = (EndpointsObj)object;
        AddressFamily afi = ePObj.getAddressFamily();
        Preconditions.checkArgument(afi instanceof Ipv6Case, "Wrong instance of NetworkAddress. Passed %s. Needed IPv6", afi.getClass());
        ByteBuf body = Unpooled.buffer(32);
        Ipv6 ipv6 = ((Ipv6Case)afi).getIpv6();
        Preconditions.checkArgument(ipv6.getSourceIpv6Address() != null, "SourceIpv6Address is mandatory.");
        ByteBufWriteUtil.writeIpv6Address(ipv6.getSourceIpv6Address(), body);
        Preconditions.checkArgument(ipv6.getDestinationIpv6Address() != null, "DestinationIpv6Address is mandatory.");
        ByteBufWriteUtil.writeIpv6Address(ipv6.getDestinationIpv6Address(), body);
        ObjectUtil.formatSubobject(2, 4, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }
}

