/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.lspa.object.lspa.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;

public class PCEPLspaObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    public static final int CLASS = 9;
    public static final int TYPE = 1;
    private static final int FLAGS_SIZE = 8;
    private static final int L_FLAG_OFFSET = 7;
    private static final int RESERVED = 1;

    public PCEPLspaObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public Lspa parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        LspaBuilder builder = new LspaBuilder();
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        builder.setExcludeAny(new AttributeFilter(bytes.readUnsignedInt()));
        builder.setIncludeAll(new AttributeFilter(bytes.readUnsignedInt()));
        builder.setIncludeAny(new AttributeFilter(bytes.readUnsignedInt()));
        builder.setSetupPriority(bytes.readUnsignedByte());
        builder.setHoldPriority(bytes.readUnsignedByte());
        BitArray flags = BitArray.valueOf(bytes.readByte());
        builder.setLocalProtectionDesired(flags.get(7));
        TlvsBuilder tbuilder = new TlvsBuilder();
        bytes.skipBytes(1);
        this.parseTlvs(tbuilder, bytes.slice());
        builder.setTlvs(tbuilder.build());
        return builder.build();
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Lspa, "Wrong instance of PCEPObject. Passed %s. Needed LspaObject.", object.getClass());
        Lspa lspaObj = (Lspa)object;
        ByteBuf body = Unpooled.buffer();
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getExcludeAny(), body);
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getIncludeAny(), body);
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getIncludeAll(), body);
        ByteBufWriteUtil.writeUnsignedByte(lspaObj.getSetupPriority(), body);
        ByteBufWriteUtil.writeUnsignedByte(lspaObj.getHoldPriority(), body);
        BitArray flags = new BitArray(8);
        flags.set(7, lspaObj.isLocalProtectionDesired());
        flags.toByteBuf(body);
        body.writeZero(1);
        this.serializeTlvs(lspaObj.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 9, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    private static void writeAttributeFilter(AttributeFilter attributeFilter, ByteBuf body) {
        ByteBufWriteUtil.writeUnsignedInt(attributeFilter != null ? attributeFilter.getValue() : null, body);
    }

    @Override
    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

