/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.open.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPOpenObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPOpenObjectParser.class);
    public static final int CLASS = 1;
    public static final int TYPE = 1;
    private static final int VERSION_SF_LENGTH = 3;
    private static final int VERSION_SF_OFFSET = 0;
    private static final int PCEP_VERSION = 1;

    public PCEPOpenObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg);
    }

    @Override
    public Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument(bytes != null && bytes.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        byte versionValue = ByteArray.copyBitsRange(bytes.readByte(), 0, 3);
        OpenBuilder builder = new OpenBuilder();
        builder.setVersion(new ProtocolVersion(Short.valueOf(versionValue)));
        builder.setProcessingRule(header.isProcessingRule());
        builder.setIgnore(header.isIgnore());
        short keepalive = bytes.readUnsignedByte();
        builder.setKeepalive(keepalive);
        short deadTimer = bytes.readUnsignedByte();
        if (keepalive == 0) {
            builder.setDeadTimer((short)0);
        } else {
            builder.setDeadTimer(deadTimer);
        }
        builder.setSessionId(bytes.readUnsignedByte());
        TlvsBuilder tbuilder = new TlvsBuilder();
        this.parseTlvs(tbuilder, bytes.slice());
        builder.setTlvs(tbuilder.build());
        Open obj = builder.build();
        if (versionValue != 1) {
            LOG.debug("Unsupported PCEP version {}", (java.lang.Object)versionValue);
            return new UnknownObject(PCEPErrors.PCEP_VERSION_NOT_SUPPORTED, obj);
        }
        return obj;
    }

    @Override
    public void addTlv(TlvsBuilder tbuilder, Tlv tlv) {
        if (tlv instanceof OfList) {
            tbuilder.setOfList((OfList)tlv);
        }
    }

    @Override
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument(object instanceof Open, "Wrong instance of PCEPObject. Passed %s. Needed OpenObject.", object.getClass());
        Open open = (Open)object;
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedByte((short)32, body);
        ByteBufWriteUtil.writeUnsignedByte(open.getKeepalive(), body);
        ByteBufWriteUtil.writeUnsignedByte(open.getDeadTimer(), body);
        Preconditions.checkArgument(open.getSessionId() != null, "SessionId is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(open.getSessionId(), body);
        this.serializeTlvs(open.getTlvs(), body);
        ObjectUtil.formatSubobject(1, 1, object.isProcessingRule(), object.isIgnore(), body, buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs == null) {
            return;
        }
        if (tlvs.getOfList() != null) {
            this.serializeTlv(tlvs.getOfList(), body);
        }
        this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
    }

    @Override
    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

