/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.pcc.mock;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opendaylight.protocol.pcep.PCEPCapability;
import org.opendaylight.protocol.pcep.ietf.stateful07.PCEPStatefulCapability;
import org.opendaylight.protocol.pcep.pcc.mock.PCCsBuilder;
import org.opendaylight.protocol.pcep.pcc.mock.TimerHandler;
import org.opendaylight.protocol.util.InetSocketAddressUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final int DEFAULT_REMOTE_PORT = 4189;
    private static final int DEFAULT_LOCAL_PORT = 0;
    private static final short DEFAULT_KEEP_ALIVE = 30;
    private static final short DEFAULT_DEAD_TIMER = 120;
    private static final InetAddress LOCALHOST = InetAddresses.forString("127.0.0.1");
    private static boolean triggeredInitSync = Boolean.FALSE;
    private static boolean includeDbv = Boolean.FALSE;
    private static boolean incrementalSync = Boolean.FALSE;
    private static boolean triggeredResync = Boolean.FALSE;
    private static BigInteger syncOptDBVersion;
    private static int reconnectAfterXSeconds;
    private static int disonnectAfterXSeconds;

    private Main() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        InetSocketAddress localAddress = new InetSocketAddress(LOCALHOST, 0);
        List<InetSocketAddress> remoteAddress = Collections.singletonList(new InetSocketAddress(LOCALHOST, 4189));
        int pccCount = 1;
        int lsps = 1;
        boolean pcError = false;
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        short ka = 30;
        short dt = 120;
        String password = null;
        long reconnectTime = -1L;
        int redelegationTimeout = 0;
        int stateTimeout = -1;
        Main.getRootLogger(lc).setLevel(Level.INFO);
        block38: for (int argIdx = 0; argIdx < args.length; ++argIdx) {
            switch (args[argIdx]) {
                case "--local-address": {
                    localAddress = InetSocketAddressUtil.getInetSocketAddress(args[++argIdx], 0);
                    continue block38;
                }
                case "--remote-address": {
                    remoteAddress = InetSocketAddressUtil.parseAddresses(args[++argIdx], 4189);
                    continue block38;
                }
                case "--pcc": {
                    pccCount = Integer.parseInt(args[++argIdx]);
                    continue block38;
                }
                case "--lsp": {
                    lsps = Integer.parseInt(args[++argIdx]);
                    continue block38;
                }
                case "--pcerr": {
                    pcError = true;
                    continue block38;
                }
                case "--log-level": {
                    Main.getRootLogger(lc).setLevel(Level.toLevel(args[++argIdx], Level.INFO));
                    continue block38;
                }
                case "--keepalive": 
                case "-ka": {
                    ka = Short.valueOf(args[++argIdx]);
                    continue block38;
                }
                case "--deadtimer": 
                case "-d": {
                    dt = Short.valueOf(args[++argIdx]);
                    continue block38;
                }
                case "--password": {
                    password = args[++argIdx];
                    continue block38;
                }
                case "--reconnect": {
                    reconnectTime = Integer.parseInt(args[++argIdx]);
                    continue block38;
                }
                case "--redelegation-timeout": {
                    redelegationTimeout = Integer.parseInt(args[++argIdx]);
                    continue block38;
                }
                case "--state-timeout": {
                    stateTimeout = Integer.parseInt(args[++argIdx]);
                    continue block38;
                }
                case "--state-sync-avoidance": {
                    includeDbv = Boolean.TRUE;
                    Long dbVersionAfterReconnect = Long.valueOf(args[++argIdx]);
                    disonnectAfterXSeconds = Integer.parseInt(args[++argIdx]);
                    reconnectAfterXSeconds = Integer.parseInt(args[++argIdx]);
                    syncOptDBVersion = BigInteger.valueOf(dbVersionAfterReconnect);
                    continue block38;
                }
                case "--incremental-sync-procedure": {
                    includeDbv = Boolean.TRUE;
                    incrementalSync = Boolean.TRUE;
                    Long initialDbVersionAfterReconnect = Long.valueOf(args[++argIdx]);
                    disonnectAfterXSeconds = Integer.parseInt(args[++argIdx]);
                    reconnectAfterXSeconds = Integer.parseInt(args[++argIdx]);
                    syncOptDBVersion = BigInteger.valueOf(initialDbVersionAfterReconnect);
                    continue block38;
                }
                case "--triggered-initial-sync": {
                    triggeredInitSync = Boolean.TRUE;
                    continue block38;
                }
                case "--triggered-re-sync": {
                    triggeredResync = Boolean.TRUE;
                    continue block38;
                }
                default: {
                    LOG.warn("WARNING: Unrecognized argument: {}", (Object)args[argIdx]);
                }
            }
        }
        if (incrementalSync) {
            Preconditions.checkArgument(syncOptDBVersion.intValue() > lsps, "Synchronization Database Version which will be used after reconnectes requires to be higher than lsps");
        }
        Optional<BigInteger> dBVersion = Optional.fromNullable(syncOptDBVersion);
        PCCsBuilder pccs = new PCCsBuilder(lsps, pcError, pccCount, localAddress, remoteAddress, ka, dt, password, reconnectTime, redelegationTimeout, stateTimeout, Main.getCapabilities());
        TimerHandler timerHandler = new TimerHandler(pccs, dBVersion, disonnectAfterXSeconds, reconnectAfterXSeconds);
        pccs.createPCCs(BigInteger.valueOf(lsps), Optional.fromNullable(timerHandler));
        if (!triggeredInitSync) {
            timerHandler.createDisconnectTask();
        }
    }

    private static PCEPCapability getCapabilities() {
        if (triggeredInitSync) {
            Preconditions.checkArgument(includeDbv);
        }
        return new PCEPStatefulCapability(true, true, true, triggeredInitSync, triggeredResync, incrementalSync, includeDbv);
    }

    private static ch.qos.logback.classic.Logger getRootLogger(LoggerContext lc) {
        return lc.getLoggerList().stream().filter(input -> input != null && input.getName().equals("ROOT")).findFirst().get();
    }
}

