/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelRegistry;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SimpleLabelRegistry
implements LabelRegistry {
    private final HandlerRegistry<DataContainer, LabelParser, LabelSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerLabelParser(int cType, LabelParser parser) {
        Preconditions.checkArgument(cType >= 0 && cType <= 255);
        return this.handlers.registerParser(cType, parser);
    }

    public AutoCloseable registerLabelSerializer(Class<? extends LabelType> labelClass, LabelSerializer serializer) {
        return this.handlers.registerSerializer(labelClass, serializer);
    }

    @Override
    public LabelType parseLabel(int cType, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(cType >= 0 && cType <= 255);
        LabelParser parser = this.handlers.getParser(cType);
        if (parser == null) {
            return null;
        }
        return parser.parseLabel(buffer);
    }

    @Override
    public void serializeLabel(boolean unidirectional, boolean global, LabelType label, ByteBuf buffer) {
        LabelSerializer serializer = this.handlers.getSerializer(label.getImplementedInterface());
        if (serializer != null) {
            serializer.serializeLabel(unidirectional, global, label, buffer);
        }
    }
}

