/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderActivator;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePCEPExtensionProviderContextActivator
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SimplePCEPExtensionProviderContextActivator.class);
    private final PCEPExtensionProviderContext providerContext;
    private final List<PCEPExtensionProviderActivator> extensionActivators;

    public SimplePCEPExtensionProviderContextActivator(PCEPExtensionProviderContext providerContext, List<PCEPExtensionProviderActivator> extensionActivators) {
        this.providerContext = Objects.requireNonNull(providerContext);
        this.extensionActivators = Objects.requireNonNull(extensionActivators);
    }

    public void start() {
        LOG.debug("Starting {} PCEPExtensionProviderActivator instances", (Object)this.extensionActivators.size());
        for (PCEPExtensionProviderActivator e : this.extensionActivators) {
            e.start(this.providerContext);
        }
    }

    @Override
    public void close() {
        LOG.debug("Stopping {} BGPExtensionProviderActivator instances", (Object)this.extensionActivators.size());
        for (PCEPExtensionProviderActivator e : this.extensionActivators) {
            e.stop();
        }
    }
}

