/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Optional;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SimpleVendorInformationTlvRegistry
implements VendorInformationTlvRegistry {
    private final HandlerRegistry<DataContainer, TlvParser, TlvSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerVendorInformationTlvParser(EnterpriseNumber enterpriseNumber, TlvParser parser) {
        return this.handlers.registerParser(Ints.checkedCast(enterpriseNumber.getValue()), parser);
    }

    public AutoCloseable registerVendorInformationTlvSerializer(Class<? extends EnterpriseSpecificInformation> esInformationClass, TlvSerializer serializer) {
        return this.handlers.registerSerializer(esInformationClass, serializer);
    }

    @Override
    public Optional<VendorInformationTlv> parseVendorInformationTlv(EnterpriseNumber enterpriseNumber, ByteBuf buffer) throws PCEPDeserializerException {
        TlvParser parser = this.handlers.getParser(Ints.checkedCast(enterpriseNumber.getValue()));
        if (parser == null) {
            return Optional.absent();
        }
        return Optional.of((VendorInformationTlv)parser.parseTlv(buffer));
    }

    @Override
    public void serializeVendorInformationTlv(VendorInformationTlv viTlv, ByteBuf buffer) {
        TlvSerializer serializer = this.handlers.getSerializer(viTlv.getEnterpriseSpecificInformation().getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeTlv(viTlv, buffer);
    }
}

