/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.testtool;

import com.google.common.collect.Lists;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPSession;
import org.opendaylight.protocol.pcep.PCEPSessionListener;
import org.opendaylight.protocol.pcep.PCEPTerminationReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingSessionListener
implements PCEPSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(TestingSessionListener.class);
    private final List<Message> messages = Lists.newArrayList();
    private boolean up = false;

    @Override
    public void onMessage(PCEPSession session, Message message) {
        LOG.debug("Received message: {}", (Object)message);
        this.messages.add(message);
    }

    @Override
    public void onSessionUp(PCEPSession session) {
        LOG.debug("Session up.");
        this.up = true;
    }

    @Override
    public void onSessionDown(PCEPSession session, Exception exception) {
        LOG.debug("Session down. Cause : {} ", (Object)exception, (Object)exception);
        this.up = false;
    }

    @Override
    public void onSessionTerminated(PCEPSession session, PCEPTerminationReason cause) {
        LOG.debug("Session terminated. Cause : {}", (Object)cause);
    }

    List<Message> messages() {
        return this.messages;
    }

    boolean isUp() {
        return this.up;
    }
}

