/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;

public final class ByteBufWriteUtil {
    public static final int SHORT_BYTES_LENGTH = 2;
    public static final int MEDIUM_BYTES_LENGTH = 3;
    public static final int INT_BYTES_LENGTH = 4;
    public static final int LONG_BYTES_LENGTH = 8;
    public static final int FLOAT32_BYTES_LENGTH = 4;
    public static final int ONE_BYTE_LENGTH = 1;
    public static final int IPV4_PREFIX_BYTE_LENGTH = 5;
    public static final int IPV6_PREFIX_BYTE_LENGTH = 17;

    private ByteBufWriteUtil() {
        throw new UnsupportedOperationException();
    }

    public static void writeInt(Integer value, ByteBuf output) {
        if (value != null) {
            output.writeInt(value);
        } else {
            output.writeZero(4);
        }
    }

    public static void writeMedium(Integer value, ByteBuf output) {
        if (value != null) {
            output.writeMedium(value);
        } else {
            output.writeZero(3);
        }
    }

    public static void writeShort(Short value, ByteBuf output) {
        if (value != null) {
            output.writeShort(value.shortValue());
        } else {
            output.writeZero(2);
        }
    }

    public static void writeLong(Long value, ByteBuf output) {
        if (value != null) {
            output.writeLong(value);
        } else {
            output.writeZero(8);
        }
    }

    public static void writeBoolean(Boolean value, ByteBuf output) {
        if (value != null) {
            output.writeBoolean(value);
        } else {
            output.writeZero(1);
        }
    }

    public static void writeUnsignedByte(Short value, ByteBuf output) {
        if (value != null) {
            output.writeByte(value.shortValue());
        } else {
            output.writeZero(1);
        }
    }

    public static void writeUnsignedShort(Integer value, ByteBuf output) {
        if (value != null) {
            output.writeShort(value.shortValue());
        } else {
            output.writeZero(2);
        }
    }

    public static void writeUnsignedInt(Long value, ByteBuf output) {
        if (value != null) {
            output.writeInt(value.intValue());
        } else {
            output.writeZero(4);
        }
    }

    public static void writeUnsignedLong(BigInteger value, ByteBuf output) {
        if (value != null) {
            output.writeLong(value.longValue());
        } else {
            output.writeZero(8);
        }
    }

    public static void writeIpv4Address(Ipv4Address ipv4Address, ByteBuf output) {
        if (ipv4Address != null) {
            output.writeBytes(Ipv4Util.bytesForAddress(ipv4Address));
        } else {
            output.writeZero(4);
        }
    }

    public static void writeIpv4Prefix(Ipv4Prefix ipv4Prefix, ByteBuf output) {
        if (ipv4Prefix != null) {
            output.writeBytes(Ipv4Util.bytesForPrefix(ipv4Prefix));
        } else {
            output.writeZero(5);
        }
    }

    public static void writeIpv6Address(Ipv6Address ipv6Address, ByteBuf output) {
        if (ipv6Address != null) {
            output.writeBytes(Ipv6Util.bytesForAddress(ipv6Address));
        } else {
            output.writeZero(16);
        }
    }

    public static void writeIpv6Prefix(Ipv6Prefix ipv6Prefix, ByteBuf output) {
        if (ipv6Prefix != null) {
            output.writeBytes(Ipv6Util.bytesForPrefix(ipv6Prefix));
        } else {
            output.writeZero(17);
        }
    }

    public static void writeMinimalPrefix(Ipv4Prefix ipv4Prefix, ByteBuf output) {
        byte[] bytes = IetfInetUtil.INSTANCE.ipv4PrefixToBytes(ipv4Prefix);
        ByteBufWriteUtil.writeMinimalPrefix(output, bytes, bytes[4]);
    }

    public static void writeMinimalPrefix(Ipv6Prefix ipv6Prefix, ByteBuf output) {
        byte[] bytes = IetfInetUtil.INSTANCE.ipv6PrefixToBytes(ipv6Prefix);
        ByteBufWriteUtil.writeMinimalPrefix(output, bytes, bytes[16]);
    }

    private static void writeMinimalPrefix(ByteBuf output, byte[] bytes, byte prefixBits) {
        output.writeByte(prefixBits);
        output.writeBytes(bytes, 0, Ipv4Util.prefixBitsToBytes(Byte.toUnsignedInt(prefixBits)));
    }

    public static void writeFloat32(Float32 value, ByteBuf output) {
        if (value != null) {
            output.writeBytes(value.getValue());
        } else {
            output.writeZero(4);
        }
    }
}

