/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import com.google.common.base.Preconditions;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;

public final class Ipv6Util {
    public static final int IPV6_LENGTH = 16;
    public static final int IPV6_BITS_LENGTH = 128;
    private static final Ipv6Prefix EMPTY_PREFIX = new Ipv6Prefix("::/0");

    private Ipv6Util() {
        throw new UnsupportedOperationException();
    }

    public static Ipv6Address getFullForm(Ipv6Address ip) {
        return new Ipv6Address(InetAddresses.forString(ip.getValue()).getHostAddress());
    }

    public static Ipv6Address addressForByteBuf(ByteBuf buffer) {
        return (Ipv6Address)IetfInetUtil.INSTANCE.ipv6AddressFor(ByteArray.readBytes(buffer, 16));
    }

    public static ByteBuf byteBufForAddress(Ipv6Address ipAddress) {
        return Unpooled.wrappedBuffer(Ipv6Util.bytesForAddress(ipAddress));
    }

    public static byte[] bytesForAddress(Ipv6Address address) {
        return IetfInetUtil.INSTANCE.ipv6AddressBytes(address);
    }

    public static byte[] bytesForPrefix(Ipv6Prefix prefix) {
        return IetfInetUtil.INSTANCE.ipv6PrefixToBytes(prefix);
    }

    public static Ipv6Prefix prefixForBytes(byte[] bytes, int length) {
        Preconditions.checkArgument(length <= bytes.length * 8);
        byte[] tmp = bytes.length != 16 ? Arrays.copyOfRange(bytes, 0, 16) : bytes;
        return (Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixFor(tmp, length);
    }

    public static Ipv6Prefix prefixForByteBuf(ByteBuf buf) {
        int prefixLength = UnsignedBytes.toInt(buf.readByte());
        int size = prefixLength / 8 + (prefixLength % 8 == 0 ? 0 : 1);
        int readable = buf.readableBytes();
        Preconditions.checkArgument(size <= readable, "Illegal length of IP prefix: %s/%s", size, readable);
        byte[] bytes = new byte[16];
        buf.readBytes(bytes, 0, size);
        return (Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixFor(bytes, prefixLength);
    }

    public static List<Ipv6Prefix> prefixListForBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Ipv6Prefix> list = new ArrayList<Ipv6Prefix>();
        int byteOffset = 0;
        while (byteOffset < bytes.length) {
            int bitLength = UnsignedBytes.toInt(bytes[byteOffset]);
            ++byteOffset;
            if (bitLength == 0) {
                list.add(EMPTY_PREFIX);
                continue;
            }
            list.add((Ipv6Prefix)IetfInetUtil.INSTANCE.ipv6PrefixForShort(bytes, byteOffset, bitLength));
            byteOffset += bitLength / 8;
            if (bitLength % 8 == 0) continue;
            ++byteOffset;
        }
        return list;
    }
}

