/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ServiceType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.Service;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.ServiceKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.services.service.Instance;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ServiceBuilder
implements Builder<Service> {
    private List<Instance> _instance;
    private ServiceKey _key;
    private Class<? extends ServiceType> _type;
    Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = Collections.emptyMap();

    public ServiceBuilder() {
    }

    public ServiceBuilder(Service base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ServiceKey(base.getType());
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._type = this._key.getType();
        }
        this._instance = base.getInstance();
        if (base instanceof ServiceImpl) {
            ServiceImpl impl = (ServiceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public List<Instance> getInstance() {
        return this._instance;
    }

    public ServiceKey getKey() {
        return this._key;
    }

    public Class<? extends ServiceType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ServiceBuilder setInstance(List<Instance> value) {
        this._instance = value;
        return this;
    }

    public ServiceBuilder setKey(ServiceKey value) {
        this._key = value;
        return this;
    }

    public ServiceBuilder setType(Class<? extends ServiceType> value) {
        this._type = value;
        return this;
    }

    public ServiceBuilder addAugmentation(Class<? extends Augmentation<Service>> augmentationType, Augmentation<Service> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ServiceBuilder removeAugmentation(Class<? extends Augmentation<Service>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Service build() {
        return new ServiceImpl(this);
    }

    private static final class ServiceImpl
    implements Service {
        private final List<Instance> _instance;
        private final ServiceKey _key;
        private final Class<? extends ServiceType> _type;
        private Map<Class<? extends Augmentation<Service>>, Augmentation<Service>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Service> getImplementedInterface() {
            return Service.class;
        }

        private ServiceImpl(ServiceBuilder base) {
            if (base.getKey() == null) {
                this._key = new ServiceKey(base.getType());
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._type = this._key.getType();
            }
            this._instance = base.getInstance();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Service>>, Augmentation<Service>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Service>>, Augmentation<Service>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Instance> getInstance() {
            return this._instance;
        }

        @Override
        public ServiceKey getKey() {
            return this._key;
        }

        @Override
        public Class<? extends ServiceType> getType() {
            return this._type;
        }

        @Override
        public <E extends Augmentation<Service>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._instance);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Service.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Service other = (Service)obj;
            if (!Objects.equals(this._instance, other.getInstance())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ServiceImpl otherImpl = (ServiceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Service>>, Augmentation<Service>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Service [";
            StringBuilder builder = new StringBuilder(name);
            if (this._instance != null) {
                builder.append("_instance=");
                builder.append(this._instance);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

