/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819;

import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Float64
implements Serializable {
    private static final long serialVersionUID = -9128437988250207037L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length >= 8 && length <= 8) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[8..8]].", Arrays.toString(value)));
    }

    @ConstructorProperties(value={"value"})
    public Float64(byte[] _value) {
        if (_value != null) {
            Float64.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public Float64(Float64 source) {
        this._value = source._value;
    }

    public static Float64 getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new Float64(baseEncoding.decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Float64 other = (Float64)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Float64.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(Arrays.toString(this._value));
        }
        return builder.append(']').toString();
    }
}

