/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.path.binding.binding.type.value;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MplsLabelEntryBuilder
implements Builder<MplsLabelEntry> {
    private MplsLabel _label;
    private Short _timeToLive;
    private Short _trafficClass;
    private Boolean _bottomOfStack;
    Map<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> augmentation = Collections.emptyMap();

    public MplsLabelEntryBuilder() {
    }

    public MplsLabelEntryBuilder(MplsLabelEntry base) {
        AugmentationHolder casted;
        this._label = base.getLabel();
        this._timeToLive = base.getTimeToLive();
        this._trafficClass = base.getTrafficClass();
        this._bottomOfStack = base.isBottomOfStack();
        if (base instanceof MplsLabelEntryImpl) {
            MplsLabelEntryImpl impl = (MplsLabelEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public MplsLabel getLabel() {
        return this._label;
    }

    public Short getTimeToLive() {
        return this._timeToLive;
    }

    public Short getTrafficClass() {
        return this._trafficClass;
    }

    public Boolean isBottomOfStack() {
        return this._bottomOfStack;
    }

    public <E extends Augmentation<MplsLabelEntry>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MplsLabelEntryBuilder setLabel(MplsLabel value) {
        this._label = value;
        return this;
    }

    private static void checkTimeToLiveRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public MplsLabelEntryBuilder setTimeToLive(Short value) {
        if (value != null) {
            MplsLabelEntryBuilder.checkTimeToLiveRange(value);
        }
        this._timeToLive = value;
        return this;
    }

    private static void checkTrafficClassRange(short value) {
        if (value >= 0 && value <= 7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..7]].", value));
    }

    public MplsLabelEntryBuilder setTrafficClass(Short value) {
        if (value != null) {
            MplsLabelEntryBuilder.checkTrafficClassRange(value);
        }
        this._trafficClass = value;
        return this;
    }

    public MplsLabelEntryBuilder setBottomOfStack(Boolean value) {
        this._bottomOfStack = value;
        return this;
    }

    public MplsLabelEntryBuilder addAugmentation(Class<? extends Augmentation<MplsLabelEntry>> augmentationType, Augmentation<MplsLabelEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MplsLabelEntryBuilder removeAugmentation(Class<? extends Augmentation<MplsLabelEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MplsLabelEntry build() {
        return new MplsLabelEntryImpl(this);
    }

    private static final class MplsLabelEntryImpl
    implements MplsLabelEntry {
        private final MplsLabel _label;
        private final Short _timeToLive;
        private final Short _trafficClass;
        private final Boolean _bottomOfStack;
        private Map<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<MplsLabelEntry> getImplementedInterface() {
            return MplsLabelEntry.class;
        }

        private MplsLabelEntryImpl(MplsLabelEntryBuilder base) {
            this._label = base.getLabel();
            this._timeToLive = base.getTimeToLive();
            this._trafficClass = base.getTrafficClass();
            this._bottomOfStack = base.isBottomOfStack();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>>(base.augmentation);
                }
            }
        }

        @Override
        public MplsLabel getLabel() {
            return this._label;
        }

        @Override
        public Short getTimeToLive() {
            return this._timeToLive;
        }

        @Override
        public Short getTrafficClass() {
            return this._trafficClass;
        }

        @Override
        public Boolean isBottomOfStack() {
            return this._bottomOfStack;
        }

        @Override
        public <E extends Augmentation<MplsLabelEntry>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._label);
            result = 31 * result + Objects.hashCode(this._timeToLive);
            result = 31 * result + Objects.hashCode(this._trafficClass);
            result = 31 * result + Objects.hashCode(this._bottomOfStack);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MplsLabelEntry.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MplsLabelEntry other = (MplsLabelEntry)obj;
            if (!Objects.equals(this._label, other.getLabel())) {
                return false;
            }
            if (!Objects.equals(this._timeToLive, other.getTimeToLive())) {
                return false;
            }
            if (!Objects.equals(this._trafficClass, other.getTrafficClass())) {
                return false;
            }
            if (!Objects.equals(this._bottomOfStack, other.isBottomOfStack())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MplsLabelEntryImpl otherImpl = (MplsLabelEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "MplsLabelEntry [";
            StringBuilder builder = new StringBuilder(name);
            if (this._label != null) {
                builder.append("_label=");
                builder.append(this._label);
                builder.append(", ");
            }
            if (this._timeToLive != null) {
                builder.append("_timeToLive=");
                builder.append(this._timeToLive);
                builder.append(", ");
            }
            if (this._trafficClass != null) {
                builder.append("_trafficClass=");
                builder.append(this._trafficClass);
                builder.append(", ");
            }
            if (this._bottomOfStack != null) {
                builder.append("_bottomOfStack=");
                builder.append(this._bottomOfStack);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

