/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.PcupdMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcupdMessageBuilder
implements Builder<PcupdMessage> {
    private List<Updates> _updates;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> augmentation = Collections.emptyMap();

    public PcupdMessageBuilder() {
    }

    public PcupdMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcupdMessageBuilder(PcupdMessage base) {
        AugmentationHolder casted;
        this._updates = base.getUpdates();
        this._version = base.getVersion();
        if (base instanceof PcupdMessageImpl) {
            PcupdMessageImpl impl = (PcupdMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public List<Updates> getUpdates() {
        return this._updates;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcupdMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcupdMessageBuilder setUpdates(List<Updates> value) {
        this._updates = value;
        return this;
    }

    public PcupdMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcupdMessageBuilder addAugmentation(Class<? extends Augmentation<PcupdMessage>> augmentationType, Augmentation<PcupdMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcupdMessageBuilder removeAugmentation(Class<? extends Augmentation<PcupdMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcupdMessage build() {
        return new PcupdMessageImpl(this);
    }

    private static final class PcupdMessageImpl
    implements PcupdMessage {
        private final List<Updates> _updates;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcupdMessage> getImplementedInterface() {
            return PcupdMessage.class;
        }

        private PcupdMessageImpl(PcupdMessageBuilder base) {
            this._updates = base.getUpdates();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Updates> getUpdates() {
            return this._updates;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public <E extends Augmentation<PcupdMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._updates);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcupdMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcupdMessage other = (PcupdMessage)obj;
            if (!Objects.equals(this._updates, other.getUpdates())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcupdMessageImpl otherImpl = (PcupdMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcupdMessage>>, Augmentation<PcupdMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcupdMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._updates != null) {
                builder.append("_updates=");
                builder.append(this._updates);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

