/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.rsvp.error.spec.error.type.rsvp._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.rsvp.error.spec.error.type.rsvp._case.RsvpError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ErrorSpec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RsvpErrorBuilder
implements Builder<RsvpError> {
    private Short _code;
    private ErrorSpec.Flags _flags;
    private IpAddress _node;
    private Integer _value;
    Map<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> augmentation = Collections.emptyMap();

    public RsvpErrorBuilder() {
    }

    public RsvpErrorBuilder(ErrorSpec arg) {
        this._node = arg.getNode();
        this._flags = arg.getFlags();
        this._code = arg.getCode();
        this._value = arg.getValue();
    }

    public RsvpErrorBuilder(RsvpError base) {
        AugmentationHolder casted;
        this._code = base.getCode();
        this._flags = base.getFlags();
        this._node = base.getNode();
        this._value = base.getValue();
        if (base instanceof RsvpErrorImpl) {
            RsvpErrorImpl impl = (RsvpErrorImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ErrorSpec) {
            this._node = ((ErrorSpec)arg).getNode();
            this._flags = ((ErrorSpec)arg).getFlags();
            this._code = ((ErrorSpec)arg).getCode();
            this._value = ((ErrorSpec)arg).getValue();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ErrorSpec] \nbut was: " + arg);
        }
    }

    public Short getCode() {
        return this._code;
    }

    public ErrorSpec.Flags getFlags() {
        return this._flags;
    }

    public IpAddress getNode() {
        return this._node;
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<RsvpError>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCodeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public RsvpErrorBuilder setCode(Short value) {
        if (value != null) {
            RsvpErrorBuilder.checkCodeRange(value);
        }
        this._code = value;
        return this;
    }

    public RsvpErrorBuilder setFlags(ErrorSpec.Flags value) {
        this._flags = value;
        return this;
    }

    public RsvpErrorBuilder setNode(IpAddress value) {
        this._node = value;
        return this;
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public RsvpErrorBuilder setValue(Integer value) {
        if (value != null) {
            RsvpErrorBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public RsvpErrorBuilder addAugmentation(Class<? extends Augmentation<RsvpError>> augmentationType, Augmentation<RsvpError> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RsvpErrorBuilder removeAugmentation(Class<? extends Augmentation<RsvpError>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public RsvpError build() {
        return new RsvpErrorImpl(this);
    }

    private static final class RsvpErrorImpl
    implements RsvpError {
        private final Short _code;
        private final ErrorSpec.Flags _flags;
        private final IpAddress _node;
        private final Integer _value;
        private Map<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<RsvpError> getImplementedInterface() {
            return RsvpError.class;
        }

        private RsvpErrorImpl(RsvpErrorBuilder base) {
            this._code = base.getCode();
            this._flags = base.getFlags();
            this._node = base.getNode();
            this._value = base.getValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getCode() {
            return this._code;
        }

        @Override
        public ErrorSpec.Flags getFlags() {
            return this._flags;
        }

        @Override
        public IpAddress getNode() {
            return this._node;
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        @Override
        public <E extends Augmentation<RsvpError>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._code);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!RsvpError.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            RsvpError other = (RsvpError)obj;
            if (!Objects.equals(this._code, other.getCode())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RsvpErrorImpl otherImpl = (RsvpErrorImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<RsvpError>>, Augmentation<RsvpError>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "RsvpError [";
            StringBuilder builder = new StringBuilder(name);
            if (this._code != null) {
                builder.append("_code=");
                builder.append(this._code);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._value != null) {
                builder.append("_value=");
                builder.append(this._value);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

