/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev171113;

import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev171113.StatefulMessagesGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev171113.StatefulMessagesStatsAug;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StatefulMessagesStatsAugBuilder
implements Builder<StatefulMessagesStatsAug> {
    private Long _lastReceivedRptMsgTimestamp;
    private Long _receivedRptMsgCount;
    private Long _sentInitMsgCount;
    private Long _sentUpdMsgCount;

    public StatefulMessagesStatsAugBuilder() {
    }

    public StatefulMessagesStatsAugBuilder(StatefulMessagesGrouping arg) {
        this._lastReceivedRptMsgTimestamp = arg.getLastReceivedRptMsgTimestamp();
        this._receivedRptMsgCount = arg.getReceivedRptMsgCount();
        this._sentUpdMsgCount = arg.getSentUpdMsgCount();
        this._sentInitMsgCount = arg.getSentInitMsgCount();
    }

    public StatefulMessagesStatsAugBuilder(StatefulMessagesStatsAug base) {
        this._lastReceivedRptMsgTimestamp = base.getLastReceivedRptMsgTimestamp();
        this._receivedRptMsgCount = base.getReceivedRptMsgCount();
        this._sentInitMsgCount = base.getSentInitMsgCount();
        this._sentUpdMsgCount = base.getSentUpdMsgCount();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatefulMessagesGrouping) {
            this._lastReceivedRptMsgTimestamp = ((StatefulMessagesGrouping)arg).getLastReceivedRptMsgTimestamp();
            this._receivedRptMsgCount = ((StatefulMessagesGrouping)arg).getReceivedRptMsgCount();
            this._sentUpdMsgCount = ((StatefulMessagesGrouping)arg).getSentUpdMsgCount();
            this._sentInitMsgCount = ((StatefulMessagesGrouping)arg).getSentInitMsgCount();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev171113.StatefulMessagesGrouping] \nbut was: " + arg);
        }
    }

    public Long getLastReceivedRptMsgTimestamp() {
        return this._lastReceivedRptMsgTimestamp;
    }

    public Long getReceivedRptMsgCount() {
        return this._receivedRptMsgCount;
    }

    public Long getSentInitMsgCount() {
        return this._sentInitMsgCount;
    }

    public Long getSentUpdMsgCount() {
        return this._sentUpdMsgCount;
    }

    private static void checkLastReceivedRptMsgTimestampRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatefulMessagesStatsAugBuilder setLastReceivedRptMsgTimestamp(Long value) {
        if (value != null) {
            StatefulMessagesStatsAugBuilder.checkLastReceivedRptMsgTimestampRange(value);
        }
        this._lastReceivedRptMsgTimestamp = value;
        return this;
    }

    private static void checkReceivedRptMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatefulMessagesStatsAugBuilder setReceivedRptMsgCount(Long value) {
        if (value != null) {
            StatefulMessagesStatsAugBuilder.checkReceivedRptMsgCountRange(value);
        }
        this._receivedRptMsgCount = value;
        return this;
    }

    private static void checkSentInitMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatefulMessagesStatsAugBuilder setSentInitMsgCount(Long value) {
        if (value != null) {
            StatefulMessagesStatsAugBuilder.checkSentInitMsgCountRange(value);
        }
        this._sentInitMsgCount = value;
        return this;
    }

    private static void checkSentUpdMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public StatefulMessagesStatsAugBuilder setSentUpdMsgCount(Long value) {
        if (value != null) {
            StatefulMessagesStatsAugBuilder.checkSentUpdMsgCountRange(value);
        }
        this._sentUpdMsgCount = value;
        return this;
    }

    @Override
    public StatefulMessagesStatsAug build() {
        return new StatefulMessagesStatsAugImpl(this);
    }

    private static final class StatefulMessagesStatsAugImpl
    implements StatefulMessagesStatsAug {
        private final Long _lastReceivedRptMsgTimestamp;
        private final Long _receivedRptMsgCount;
        private final Long _sentInitMsgCount;
        private final Long _sentUpdMsgCount;
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<StatefulMessagesStatsAug> getImplementedInterface() {
            return StatefulMessagesStatsAug.class;
        }

        private StatefulMessagesStatsAugImpl(StatefulMessagesStatsAugBuilder base) {
            this._lastReceivedRptMsgTimestamp = base.getLastReceivedRptMsgTimestamp();
            this._receivedRptMsgCount = base.getReceivedRptMsgCount();
            this._sentInitMsgCount = base.getSentInitMsgCount();
            this._sentUpdMsgCount = base.getSentUpdMsgCount();
        }

        @Override
        public Long getLastReceivedRptMsgTimestamp() {
            return this._lastReceivedRptMsgTimestamp;
        }

        @Override
        public Long getReceivedRptMsgCount() {
            return this._receivedRptMsgCount;
        }

        @Override
        public Long getSentInitMsgCount() {
            return this._sentInitMsgCount;
        }

        @Override
        public Long getSentUpdMsgCount() {
            return this._sentUpdMsgCount;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lastReceivedRptMsgTimestamp);
            result = 31 * result + Objects.hashCode(this._receivedRptMsgCount);
            result = 31 * result + Objects.hashCode(this._sentInitMsgCount);
            this.hash = result = 31 * result + Objects.hashCode(this._sentUpdMsgCount);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!StatefulMessagesStatsAug.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            StatefulMessagesStatsAug other = (StatefulMessagesStatsAug)obj;
            if (!Objects.equals(this._lastReceivedRptMsgTimestamp, other.getLastReceivedRptMsgTimestamp())) {
                return false;
            }
            if (!Objects.equals(this._receivedRptMsgCount, other.getReceivedRptMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._sentInitMsgCount, other.getSentInitMsgCount())) {
                return false;
            }
            return Objects.equals(this._sentUpdMsgCount, other.getSentUpdMsgCount());
        }

        public String toString() {
            String name = "StatefulMessagesStatsAug [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lastReceivedRptMsgTimestamp != null) {
                builder.append("_lastReceivedRptMsgTimestamp=");
                builder.append(this._lastReceivedRptMsgTimestamp);
                builder.append(", ");
            }
            if (this._receivedRptMsgCount != null) {
                builder.append("_receivedRptMsgCount=");
                builder.append(this._receivedRptMsgCount);
                builder.append(", ");
            }
            if (this._sentInitMsgCount != null) {
                builder.append("_sentInitMsgCount=");
                builder.append(this._sentInitMsgCount);
                builder.append(", ");
            }
            if (this._sentUpdMsgCount != null) {
                builder.append("_sentUpdMsgCount=");
                builder.append(this._sentUpdMsgCount);
            }
            return builder.append(']').toString();
        }
    }
}

