/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Endpoints;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.endpoints.object.EndpointsObj;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EndpointsObjBuilder
implements Builder<EndpointsObj> {
    private AddressFamily _addressFamily;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = Collections.emptyMap();

    public EndpointsObjBuilder() {
    }

    public EndpointsObjBuilder(Endpoints arg) {
        this._addressFamily = arg.getAddressFamily();
    }

    public EndpointsObjBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public EndpointsObjBuilder(EndpointsObj base) {
        AugmentationHolder casted;
        this._addressFamily = base.getAddressFamily();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof EndpointsObjImpl) {
            EndpointsObjImpl impl = (EndpointsObjImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (arg instanceof Endpoints) {
            this._addressFamily = ((Endpoints)arg).getAddressFamily();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Endpoints] \nbut was: " + arg);
        }
    }

    public AddressFamily getAddressFamily() {
        return this._addressFamily;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<EndpointsObj>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public EndpointsObjBuilder setAddressFamily(AddressFamily value) {
        this._addressFamily = value;
        return this;
    }

    public EndpointsObjBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public EndpointsObjBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public EndpointsObjBuilder addAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType, Augmentation<EndpointsObj> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EndpointsObjBuilder removeAugmentation(Class<? extends Augmentation<EndpointsObj>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public EndpointsObj build() {
        return new EndpointsObjImpl(this);
    }

    private static final class EndpointsObjImpl
    implements EndpointsObj {
        private final AddressFamily _addressFamily;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<EndpointsObj> getImplementedInterface() {
            return EndpointsObj.class;
        }

        private EndpointsObjImpl(EndpointsObjBuilder base) {
            this._addressFamily = base.getAddressFamily();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>>(base.augmentation);
                }
            }
        }

        @Override
        public AddressFamily getAddressFamily() {
            return this._addressFamily;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public <E extends Augmentation<EndpointsObj>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._addressFamily);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!EndpointsObj.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            EndpointsObj other = (EndpointsObj)obj;
            if (!Objects.equals(this._addressFamily, other.getAddressFamily())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EndpointsObjImpl otherImpl = (EndpointsObjImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<EndpointsObj>>, Augmentation<EndpointsObj>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "EndpointsObj [";
            StringBuilder builder = new StringBuilder(name);
            if (this._addressFamily != null) {
                builder.append("_addressFamily=");
                builder.append(this._addressFamily);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

