/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.key.object.path.key.PathKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKeySubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathKeysBuilder
implements Builder<PathKeys> {
    private PathKey _pathKey;
    private PceId _pceId;
    private Boolean _loose;
    Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> augmentation = Collections.emptyMap();

    public PathKeysBuilder() {
    }

    public PathKeysBuilder(PathKeySubobject arg) {
        this._pceId = arg.getPceId();
        this._pathKey = arg.getPathKey();
    }

    public PathKeysBuilder(PathKeys base) {
        AugmentationHolder casted;
        this._pathKey = base.getPathKey();
        this._pceId = base.getPceId();
        this._loose = base.isLoose();
        if (base instanceof PathKeysImpl) {
            PathKeysImpl impl = (PathKeysImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PathKeySubobject) {
            this._pceId = ((PathKeySubobject)arg).getPceId();
            this._pathKey = ((PathKeySubobject)arg).getPathKey();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKeySubobject] \nbut was: " + arg);
        }
    }

    public PathKey getPathKey() {
        return this._pathKey;
    }

    public PceId getPceId() {
        return this._pceId;
    }

    public Boolean isLoose() {
        return this._loose;
    }

    public <E extends Augmentation<PathKeys>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PathKeysBuilder setPathKey(PathKey value) {
        this._pathKey = value;
        return this;
    }

    public PathKeysBuilder setPceId(PceId value) {
        this._pceId = value;
        return this;
    }

    public PathKeysBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public PathKeysBuilder addAugmentation(Class<? extends Augmentation<PathKeys>> augmentationType, Augmentation<PathKeys> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathKeysBuilder removeAugmentation(Class<? extends Augmentation<PathKeys>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PathKeys build() {
        return new PathKeysImpl(this);
    }

    private static final class PathKeysImpl
    implements PathKeys {
        private final PathKey _pathKey;
        private final PceId _pceId;
        private final Boolean _loose;
        private Map<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PathKeys> getImplementedInterface() {
            return PathKeys.class;
        }

        private PathKeysImpl(PathKeysBuilder base) {
            this._pathKey = base.getPathKey();
            this._pceId = base.getPceId();
            this._loose = base.isLoose();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>>(base.augmentation);
                }
            }
        }

        @Override
        public PathKey getPathKey() {
            return this._pathKey;
        }

        @Override
        public PceId getPceId() {
            return this._pceId;
        }

        @Override
        public Boolean isLoose() {
            return this._loose;
        }

        @Override
        public <E extends Augmentation<PathKeys>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._pathKey);
            result = 31 * result + Objects.hashCode(this._pceId);
            result = 31 * result + Objects.hashCode(this._loose);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathKeys.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathKeys other = (PathKeys)obj;
            if (!Objects.equals(this._pathKey, other.getPathKey())) {
                return false;
            }
            if (!Objects.equals(this._pceId, other.getPceId())) {
                return false;
            }
            if (!Objects.equals(this._loose, other.isLoose())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathKeysImpl otherImpl = (PathKeysImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathKeys>>, Augmentation<PathKeys>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PathKeys [";
            StringBuilder builder = new StringBuilder(name);
            if (this._pathKey != null) {
                builder.append("_pathKey=");
                builder.append(this._pathKey);
                builder.append(", ");
            }
            if (this._pceId != null) {
                builder.append("_pceId=");
                builder.append(this._pceId);
                builder.append(", ");
            }
            if (this._loose != null) {
                builder.append("_loose=");
                builder.append(this._loose);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

