/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.PcntfMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcntf.message.pcntf.message.Notifications;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcntfMessageBuilder
implements Builder<PcntfMessage> {
    private List<Notifications> _notifications;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> augmentation = Collections.emptyMap();

    public PcntfMessageBuilder() {
    }

    public PcntfMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public PcntfMessageBuilder(PcntfMessage base) {
        AugmentationHolder casted;
        this._notifications = base.getNotifications();
        this._version = base.getVersion();
        if (base instanceof PcntfMessageImpl) {
            PcntfMessageImpl impl = (PcntfMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader] \nbut was: " + arg);
        }
    }

    public List<Notifications> getNotifications() {
        return this._notifications;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<PcntfMessage>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcntfMessageBuilder setNotifications(List<Notifications> value) {
        this._notifications = value;
        return this;
    }

    public PcntfMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public PcntfMessageBuilder addAugmentation(Class<? extends Augmentation<PcntfMessage>> augmentationType, Augmentation<PcntfMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcntfMessageBuilder removeAugmentation(Class<? extends Augmentation<PcntfMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcntfMessage build() {
        return new PcntfMessageImpl(this);
    }

    private static final class PcntfMessageImpl
    implements PcntfMessage {
        private final List<Notifications> _notifications;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcntfMessage> getImplementedInterface() {
            return PcntfMessage.class;
        }

        private PcntfMessageImpl(PcntfMessageBuilder base) {
            this._notifications = base.getNotifications();
            this._version = base.getVersion();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Notifications> getNotifications() {
            return this._notifications;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public <E extends Augmentation<PcntfMessage>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._notifications);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcntfMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcntfMessage other = (PcntfMessage)obj;
            if (!Objects.equals(this._notifications, other.getNotifications())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcntfMessageImpl otherImpl = (PcntfMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcntfMessage>>, Augmentation<PcntfMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcntfMessage [";
            StringBuilder builder = new StringBuilder(name);
            if (this._notifications != null) {
                builder.append("_notifications=");
                builder.append(this._notifications);
                builder.append(", ");
            }
            if (this._version != null) {
                builder.append("_version=");
                builder.append(this._version);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

