/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PccIdReqObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RepliesBuilder
implements Builder<Replies> {
    private List<MetricPce> _metricPce;
    private Monitoring _monitoring;
    private PccIdReq _pccIdReq;
    private Result _result;
    private Rp _rp;
    private List<VendorInformationObject> _vendorInformationObject;
    Map<Class<? extends Augmentation<Replies>>, Augmentation<Replies>> augmentation = Collections.emptyMap();

    public RepliesBuilder() {
    }

    public RepliesBuilder(VendorInformationObjects arg) {
        this._vendorInformationObject = arg.getVendorInformationObject();
    }

    public RepliesBuilder(RpObject arg) {
        this._rp = arg.getRp();
    }

    public RepliesBuilder(PccIdReqObject arg) {
        this._pccIdReq = arg.getPccIdReq();
    }

    public RepliesBuilder(MonitoringObject arg) {
        this._monitoring = arg.getMonitoring();
    }

    public RepliesBuilder(MonitoringMetrics arg) {
        this._metricPce = arg.getMetricPce();
    }

    public RepliesBuilder(Replies base) {
        AugmentationHolder casted;
        this._metricPce = base.getMetricPce();
        this._monitoring = base.getMonitoring();
        this._pccIdReq = base.getPccIdReq();
        this._result = base.getResult();
        this._rp = base.getRp();
        this._vendorInformationObject = base.getVendorInformationObject();
        if (base instanceof RepliesImpl) {
            RepliesImpl impl = (RepliesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Replies>>, Augmentation<Replies>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VendorInformationObjects) {
            this._vendorInformationObject = ((VendorInformationObjects)arg).getVendorInformationObject();
            isValidArg = true;
        }
        if (arg instanceof PccIdReqObject) {
            this._pccIdReq = ((PccIdReqObject)arg).getPccIdReq();
            isValidArg = true;
        }
        if (arg instanceof MonitoringMetrics) {
            this._metricPce = ((MonitoringMetrics)arg).getMetricPce();
            isValidArg = true;
        }
        if (arg instanceof RpObject) {
            this._rp = ((RpObject)arg).getRp();
            isValidArg = true;
        }
        if (arg instanceof MonitoringObject) {
            this._monitoring = ((MonitoringObject)arg).getMonitoring();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationObjects, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PccIdReqObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringMetrics, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RpObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MonitoringObject] \nbut was: " + arg);
        }
    }

    public List<MetricPce> getMetricPce() {
        return this._metricPce;
    }

    public Monitoring getMonitoring() {
        return this._monitoring;
    }

    public PccIdReq getPccIdReq() {
        return this._pccIdReq;
    }

    public Result getResult() {
        return this._result;
    }

    public Rp getRp() {
        return this._rp;
    }

    public List<VendorInformationObject> getVendorInformationObject() {
        return this._vendorInformationObject;
    }

    public <E extends Augmentation<Replies>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public RepliesBuilder setMetricPce(List<MetricPce> value) {
        this._metricPce = value;
        return this;
    }

    public RepliesBuilder setMonitoring(Monitoring value) {
        this._monitoring = value;
        return this;
    }

    public RepliesBuilder setPccIdReq(PccIdReq value) {
        this._pccIdReq = value;
        return this;
    }

    public RepliesBuilder setResult(Result value) {
        this._result = value;
        return this;
    }

    public RepliesBuilder setRp(Rp value) {
        this._rp = value;
        return this;
    }

    public RepliesBuilder setVendorInformationObject(List<VendorInformationObject> value) {
        this._vendorInformationObject = value;
        return this;
    }

    public RepliesBuilder addAugmentation(Class<? extends Augmentation<Replies>> augmentationType, Augmentation<Replies> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Replies>>, Augmentation<Replies>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RepliesBuilder removeAugmentation(Class<? extends Augmentation<Replies>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Replies build() {
        return new RepliesImpl(this);
    }

    private static final class RepliesImpl
    implements Replies {
        private final List<MetricPce> _metricPce;
        private final Monitoring _monitoring;
        private final PccIdReq _pccIdReq;
        private final Result _result;
        private final Rp _rp;
        private final List<VendorInformationObject> _vendorInformationObject;
        private Map<Class<? extends Augmentation<Replies>>, Augmentation<Replies>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Replies> getImplementedInterface() {
            return Replies.class;
        }

        private RepliesImpl(RepliesBuilder base) {
            this._metricPce = base.getMetricPce();
            this._monitoring = base.getMonitoring();
            this._pccIdReq = base.getPccIdReq();
            this._result = base.getResult();
            this._rp = base.getRp();
            this._vendorInformationObject = base.getVendorInformationObject();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Replies>>, Augmentation<Replies>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Replies>>, Augmentation<Replies>>(base.augmentation);
                }
            }
        }

        @Override
        public List<MetricPce> getMetricPce() {
            return this._metricPce;
        }

        @Override
        public Monitoring getMonitoring() {
            return this._monitoring;
        }

        @Override
        public PccIdReq getPccIdReq() {
            return this._pccIdReq;
        }

        @Override
        public Result getResult() {
            return this._result;
        }

        @Override
        public Rp getRp() {
            return this._rp;
        }

        @Override
        public List<VendorInformationObject> getVendorInformationObject() {
            return this._vendorInformationObject;
        }

        @Override
        public <E extends Augmentation<Replies>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metricPce);
            result = 31 * result + Objects.hashCode(this._monitoring);
            result = 31 * result + Objects.hashCode(this._pccIdReq);
            result = 31 * result + Objects.hashCode(this._result);
            result = 31 * result + Objects.hashCode(this._rp);
            result = 31 * result + Objects.hashCode(this._vendorInformationObject);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Replies.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Replies other = (Replies)obj;
            if (!Objects.equals(this._metricPce, other.getMetricPce())) {
                return false;
            }
            if (!Objects.equals(this._monitoring, other.getMonitoring())) {
                return false;
            }
            if (!Objects.equals(this._pccIdReq, other.getPccIdReq())) {
                return false;
            }
            if (!Objects.equals(this._result, other.getResult())) {
                return false;
            }
            if (!Objects.equals(this._rp, other.getRp())) {
                return false;
            }
            if (!Objects.equals(this._vendorInformationObject, other.getVendorInformationObject())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RepliesImpl otherImpl = (RepliesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Replies>>, Augmentation<Replies>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Replies [";
            StringBuilder builder = new StringBuilder(name);
            if (this._metricPce != null) {
                builder.append("_metricPce=");
                builder.append(this._metricPce);
                builder.append(", ");
            }
            if (this._monitoring != null) {
                builder.append("_monitoring=");
                builder.append(this._monitoring);
                builder.append(", ");
            }
            if (this._pccIdReq != null) {
                builder.append("_pccIdReq=");
                builder.append(this._pccIdReq);
                builder.append(", ");
            }
            if (this._result != null) {
                builder.append("_result=");
                builder.append(this._result);
                builder.append(", ");
            }
            if (this._rp != null) {
                builder.append("_rp=");
                builder.append(this._rp);
                builder.append(", ");
            }
            if (this._vendorInformationObject != null) {
                builder.append("_vendorInformationObject=");
                builder.append(this._vendorInformationObject);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

