/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum InstructionStatus {
    Queued(0, "queued"),
    Scheduled(1, "scheduled"),
    Executing(2, "executing"),
    Cancelled(3, "cancelled"),
    Failed(4, "failed"),
    Successful(5, "successful"),
    Unknown(6, "unknown");

    private static final Map<Integer, InstructionStatus> VALUE_MAP;
    private final String name;
    private final int value;

    private InstructionStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static InstructionStatus forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, InstructionStatus> b = ImmutableMap.builder();
        for (InstructionStatus enumItem : InstructionStatus.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

