/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum LspFlag {
    Unprotected(0, "unprotected"),
    FullRerouting(1, "full-rerouting"),
    ReroutingWithoutExtraTraffic(2, "rerouting-without-extra-traffic"),
    ProtectionWithExtraTraffic(4, "protection-with-extra-traffic"),
    UnidirectionalProtection(8, "unidirectional-protection"),
    BidirectionalProtection(10, "bidirectional-protection");

    private static final Map<Integer, LspFlag> VALUE_MAP;
    private final String name;
    private final int value;

    private LspFlag(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static LspFlag forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, LspFlag> b = ImmutableMap.builder();
        for (LspFlag enumItem : LspFlag.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

