/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AssociationType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.association.object.AssociationObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class AssociationObjectBuilder
implements Builder<AssociationObject> {
    private Integer _associationId;
    private AssociationType _associationType;
    private IpAddress _ipAddress;
    Map<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>> augmentation = Collections.emptyMap();

    public AssociationObjectBuilder() {
    }

    public AssociationObjectBuilder(AssociationObject base) {
        AugmentationHolder casted;
        this._associationId = base.getAssociationId();
        this._associationType = base.getAssociationType();
        this._ipAddress = base.getIpAddress();
        if (base instanceof AssociationObjectImpl) {
            AssociationObjectImpl impl = (AssociationObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Integer getAssociationId() {
        return this._associationId;
    }

    public AssociationType getAssociationType() {
        return this._associationType;
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public <E extends Augmentation<AssociationObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkAssociationIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public AssociationObjectBuilder setAssociationId(Integer value) {
        if (value != null) {
            AssociationObjectBuilder.checkAssociationIdRange(value);
        }
        this._associationId = value;
        return this;
    }

    public AssociationObjectBuilder setAssociationType(AssociationType value) {
        this._associationType = value;
        return this;
    }

    public AssociationObjectBuilder setIpAddress(IpAddress value) {
        this._ipAddress = value;
        return this;
    }

    public AssociationObjectBuilder addAugmentation(Class<? extends Augmentation<AssociationObject>> augmentationType, Augmentation<AssociationObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public AssociationObjectBuilder removeAugmentation(Class<? extends Augmentation<AssociationObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AssociationObject build() {
        return new AssociationObjectImpl(this);
    }

    private static final class AssociationObjectImpl
    implements AssociationObject {
        private final Integer _associationId;
        private final AssociationType _associationType;
        private final IpAddress _ipAddress;
        private Map<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<AssociationObject> getImplementedInterface() {
            return AssociationObject.class;
        }

        private AssociationObjectImpl(AssociationObjectBuilder base) {
            this._associationId = base.getAssociationId();
            this._associationType = base.getAssociationType();
            this._ipAddress = base.getIpAddress();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getAssociationId() {
            return this._associationId;
        }

        @Override
        public AssociationType getAssociationType() {
            return this._associationType;
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public <E extends Augmentation<AssociationObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._associationId);
            result = 31 * result + Objects.hashCode((Object)this._associationType);
            result = 31 * result + Objects.hashCode(this._ipAddress);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AssociationObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AssociationObject other = (AssociationObject)obj;
            if (!Objects.equals(this._associationId, other.getAssociationId())) {
                return false;
            }
            if (!Objects.equals((Object)this._associationType, (Object)other.getAssociationType())) {
                return false;
            }
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                AssociationObjectImpl otherImpl = (AssociationObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<AssociationObject>>, Augmentation<AssociationObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "AssociationObject [";
            StringBuilder builder = new StringBuilder(name);
            if (this._associationId != null) {
                builder.append("_associationId=");
                builder.append(this._associationId);
                builder.append(", ");
            }
            if (this._associationType != null) {
                builder.append("_associationType=");
                builder.append((Object)this._associationType);
                builder.append(", ");
            }
            if (this._ipAddress != null) {
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

