/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum FailureType {
    Unsent(0, "unsent"),
    NoAck(1, "no-ack"),
    Failed(2, "failed");

    private static final Map<Integer, FailureType> VALUE_MAP;
    private final String name;
    private final int value;

    private FailureType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static FailureType forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, FailureType> b = ImmutableMap.builder();
        for (FailureType enumItem : FailureType.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

