/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum PccSyncState {
    InitialResync(0, "initial-resync"),
    IncrementalSync(1, "incremental-sync"),
    TriggeredInitialSync(2, "triggered-initial-sync"),
    PcepTriggeredResync(3, "pcep-triggered-resync"),
    Synchronized(4, "synchronized");

    private static final Map<Integer, PccSyncState> VALUE_MAP;
    private final String name;
    private final int value;

    private PccSyncState(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static PccSyncState forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, PccSyncState> b = ImmutableMap.builder();
        for (PccSyncState enumItem : PccSyncState.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

