/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.PathId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.PathsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.rev130819.network.topology.topology.paths.PathTypes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathsBuilder
implements Builder<Paths> {
    private PathsKey _key;
    private PathId _pathId;
    private PathTypes _pathTypes;
    Map<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> augmentation = Collections.emptyMap();

    public PathsBuilder() {
    }

    public PathsBuilder(Paths base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new PathsKey(base.getPathId());
            this._pathId = base.getPathId();
        } else {
            this._key = base.getKey();
            this._pathId = this._key.getPathId();
        }
        this._pathTypes = base.getPathTypes();
        if (base instanceof PathsImpl) {
            PathsImpl impl = (PathsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Paths>>, Augmentation<Paths>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public PathsKey getKey() {
        return this._key;
    }

    public PathId getPathId() {
        return this._pathId;
    }

    public PathTypes getPathTypes() {
        return this._pathTypes;
    }

    public <E extends Augmentation<Paths>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PathsBuilder setKey(PathsKey value) {
        this._key = value;
        return this;
    }

    public PathsBuilder setPathId(PathId value) {
        this._pathId = value;
        return this;
    }

    public PathsBuilder setPathTypes(PathTypes value) {
        this._pathTypes = value;
        return this;
    }

    public PathsBuilder addAugmentation(Class<? extends Augmentation<Paths>> augmentationType, Augmentation<Paths> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Paths>>, Augmentation<Paths>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathsBuilder removeAugmentation(Class<? extends Augmentation<Paths>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Paths build() {
        return new PathsImpl(this);
    }

    private static final class PathsImpl
    implements Paths {
        private final PathsKey _key;
        private final PathId _pathId;
        private final PathTypes _pathTypes;
        private Map<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Paths> getImplementedInterface() {
            return Paths.class;
        }

        private PathsImpl(PathsBuilder base) {
            if (base.getKey() == null) {
                this._key = new PathsKey(base.getPathId());
                this._pathId = base.getPathId();
            } else {
                this._key = base.getKey();
                this._pathId = this._key.getPathId();
            }
            this._pathTypes = base.getPathTypes();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Paths>>, Augmentation<Paths>>(base.augmentation);
                }
            }
        }

        @Override
        public PathsKey getKey() {
            return this._key;
        }

        @Override
        public PathId getPathId() {
            return this._pathId;
        }

        @Override
        public PathTypes getPathTypes() {
            return this._pathTypes;
        }

        @Override
        public <E extends Augmentation<Paths>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._pathId);
            result = 31 * result + Objects.hashCode(this._pathTypes);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Paths.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Paths other = (Paths)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._pathId, other.getPathId())) {
                return false;
            }
            if (!Objects.equals(this._pathTypes, other.getPathTypes())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathsImpl otherImpl = (PathsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Paths>>, Augmentation<Paths>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Paths [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._pathId != null) {
                builder.append("_pathId=");
                builder.append(this._pathId);
                builder.append(", ");
            }
            if (this._pathTypes != null) {
                builder.append("_pathTypes=");
                builder.append(this._pathTypes);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

