/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.node.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.node.attributes.SupportingNodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SupportingNodeBuilder
implements Builder<SupportingNode> {
    private SupportingNodeKey _key;
    private NodeId _nodeRef;
    Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();

    public SupportingNodeBuilder() {
    }

    public SupportingNodeBuilder(SupportingNode base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SupportingNodeKey(base.getNodeRef());
            this._nodeRef = base.getNodeRef();
        } else {
            this._key = base.getKey();
            this._nodeRef = this._key.getNodeRef();
        }
        if (base instanceof SupportingNodeImpl) {
            SupportingNodeImpl impl = (SupportingNodeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public SupportingNodeKey getKey() {
        return this._key;
    }

    public NodeId getNodeRef() {
        return this._nodeRef;
    }

    public <E extends Augmentation<SupportingNode>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SupportingNodeBuilder setKey(SupportingNodeKey value) {
        this._key = value;
        return this;
    }

    public SupportingNodeBuilder setNodeRef(NodeId value) {
        this._nodeRef = value;
        return this;
    }

    public SupportingNodeBuilder addAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType, Augmentation<SupportingNode> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SupportingNodeBuilder removeAugmentation(Class<? extends Augmentation<SupportingNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SupportingNode build() {
        return new SupportingNodeImpl(this);
    }

    private static final class SupportingNodeImpl
    implements SupportingNode {
        private final SupportingNodeKey _key;
        private final NodeId _nodeRef;
        private Map<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SupportingNode> getImplementedInterface() {
            return SupportingNode.class;
        }

        private SupportingNodeImpl(SupportingNodeBuilder base) {
            if (base.getKey() == null) {
                this._key = new SupportingNodeKey(base.getNodeRef());
                this._nodeRef = base.getNodeRef();
            } else {
                this._key = base.getKey();
                this._nodeRef = this._key.getNodeRef();
            }
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>>(base.augmentation);
                }
            }
        }

        @Override
        public SupportingNodeKey getKey() {
            return this._key;
        }

        @Override
        public NodeId getNodeRef() {
            return this._nodeRef;
        }

        @Override
        public <E extends Augmentation<SupportingNode>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._nodeRef);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SupportingNode.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SupportingNode other = (SupportingNode)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._nodeRef, other.getNodeRef())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SupportingNodeImpl otherImpl = (SupportingNodeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SupportingNode>>, Augmentation<SupportingNode>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SupportingNode [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._nodeRef != null) {
                builder.append("_nodeRef=");
                builder.append(this._nodeRef);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

