/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.base.VerifyException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.yangtools.triemap.BasicNode;
import org.opendaylight.yangtools.triemap.CNode;
import org.opendaylight.yangtools.triemap.FailedNode;
import org.opendaylight.yangtools.triemap.Gen;
import org.opendaylight.yangtools.triemap.ImmutableTrieMap;
import org.opendaylight.yangtools.triemap.LNode;
import org.opendaylight.yangtools.triemap.LNodeEntry;
import org.opendaylight.yangtools.triemap.LookupResult;
import org.opendaylight.yangtools.triemap.MainNode;
import org.opendaylight.yangtools.triemap.PresencePredicate;
import org.opendaylight.yangtools.triemap.SNode;
import org.opendaylight.yangtools.triemap.TNode;
import org.opendaylight.yangtools.triemap.TrieMap;

final class INode<K, V>
extends BasicNode {
    private static final AtomicReferenceFieldUpdater<INode, MainNode> MAINNODE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(INode.class, MainNode.class, "mainnode");
    private final Gen gen;
    private volatile MainNode<K, V> mainnode;

    INode(Gen gen, MainNode<K, V> mainnode) {
        this.gen = gen;
        this.mainnode = mainnode;
    }

    MainNode<K, V> gcasRead(TrieMap<?, ?> ct) {
        return this.GCAS_READ(ct);
    }

    private MainNode<K, V> GCAS_READ(TrieMap<?, ?> ct) {
        MainNode<K, V> m = this.mainnode;
        MainNode<K, V> prevval = m.readPrev();
        if (prevval == null) {
            return m;
        }
        return this.GCAS_Complete(m, ct);
    }

    private MainNode<K, V> GCAS_Complete(MainNode<K, V> oldmain, TrieMap<?, ?> ct) {
        MainNode<K, V> m = oldmain;
        while (m != null) {
            MainNode<K, V> prev = m.readPrev();
            INode<?, ?> ctr = ct.readRoot(true);
            if (prev == null) {
                return m;
            }
            if (prev instanceof FailedNode) {
                FailedNode fn = (FailedNode)prev;
                if (MAINNODE_UPDATER.compareAndSet(this, m, fn.readPrev())) {
                    return fn.readPrev();
                }
                m = this.mainnode;
                continue;
            }
            if (ctr.gen == this.gen && !ct.isReadOnly()) {
                if (!m.casPrev(prev, null)) continue;
                return m;
            }
            m.casPrev(prev, new FailedNode<K, V>(prev));
            m = this.mainnode;
        }
        return null;
    }

    private boolean GCAS(MainNode<K, V> old, MainNode<K, V> n, TrieMap<?, ?> ct) {
        n.writePrev(old);
        if (MAINNODE_UPDATER.compareAndSet(this, old, n)) {
            this.GCAS_Complete(n, ct);
            return n.readPrev() == null;
        }
        return false;
    }

    private INode<K, V> inode(MainNode<K, V> cn) {
        return new INode<K, V>(this.gen, cn);
    }

    INode<K, V> copyToGen(Gen ngen, TrieMap<?, ?> ct) {
        return new INode<K, V>(ngen, this.GCAS_READ(ct));
    }

    boolean recInsert(K key, V value, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recInsert(key, value, hc, lev, parent, this.gen, ct);
    }

    private boolean recInsert(K k, V v, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m;
        while ((m = this.GCAS_READ(ct)) instanceof CNode) {
            CNode<K, V> cn = (CNode<K, V>)m;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            int bmp = cn.bitmap;
            int mask = flag - 1;
            int pos = Integer.bitCount(bmp & mask);
            if ((bmp & flag) != 0) {
                BasicNode cnAtPos = cn.array[pos];
                if (cnAtPos instanceof INode) {
                    INode in = (INode)cnAtPos;
                    if (startgen == in.gen) {
                        return in.recInsert(k, v, hc, lev + 5, this, startgen, ct);
                    }
                    if (this.GCAS(cn, cn.renewed(startgen, ct), ct)) continue;
                    return false;
                }
                if (cnAtPos instanceof SNode) {
                    SNode sn = (SNode)cnAtPos;
                    if (sn.hc == hc && ct.equal(sn.key, k)) {
                        return this.GCAS(cn, cn.updatedAt(pos, new SNode<K, V>(k, v, hc), this.gen), ct);
                    }
                    CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
                    CNode<K, V> nn = rn.updatedAt(pos, this.inode(CNode.dual(sn, k, v, hc, lev + 5, this.gen)), this.gen);
                    return this.GCAS(cn, nn, ct);
                }
                throw CNode.invalidElement(cnAtPos);
            }
            CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
            CNode<K, V> ncnode = rn.insertedAt(pos, flag, new SNode<K, V>(k, v, hc), this.gen);
            return this.GCAS(cn, ncnode, ct);
        }
        if (m instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return false;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            LNodeEntry entry = ln.get(ct.equiv(), k);
            return entry != null ? this.replaceln(ln, entry, v, ct) : this.insertln(ln, k, v, ct);
        }
        throw INode.invalidElement(m);
    }

    private static VerifyException invalidElement(BasicNode elem) {
        throw new VerifyException("An INode can host only a CNode, a TNode or an LNode, not " + elem);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> insertDual(TrieMap<K, V> ct, CNode<K, V> cn, int pos, SNode<K, V> sn, K k, V v, int hc, int lev) {
        CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
        CNode<K, V> nn = rn.updatedAt(pos, this.inode(CNode.dual(sn, k, v, hc, lev + 5, this.gen)), this.gen);
        return this.GCAS(cn, nn, ct) ? Optional.empty() : null;
    }

    Optional<V> recInsertIf(K k, V v, int hc, Object cond, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recInsertIf(k, v, hc, cond, lev, parent, this.gen, ct);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> recInsertIf(K k, V v, int hc, Object cond, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m;
        while ((m = this.GCAS_READ(ct)) instanceof CNode) {
            CNode<K, V> cn = (CNode<K, V>)m;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            int bmp = cn.bitmap;
            int mask = flag - 1;
            int pos = Integer.bitCount(bmp & mask);
            if ((bmp & flag) != 0) {
                BasicNode cnAtPos = cn.array[pos];
                if (cnAtPos instanceof INode) {
                    INode in = (INode)cnAtPos;
                    if (startgen == in.gen) {
                        return in.recInsertIf(k, v, hc, cond, lev + 5, this, startgen, ct);
                    }
                    if (this.GCAS(cn, cn.renewed(startgen, ct), ct)) continue;
                    return null;
                }
                if (cnAtPos instanceof SNode) {
                    SNode sn = (SNode)cnAtPos;
                    if (cond == null) {
                        if (sn.hc == hc && ct.equal(sn.key, k)) {
                            if (this.GCAS(cn, cn.updatedAt(pos, new SNode<K, V>(k, v, hc), this.gen), ct)) {
                                return Optional.of(sn.value);
                            }
                            return null;
                        }
                        return this.insertDual(ct, cn, pos, sn, k, v, hc, lev);
                    }
                    if (cond == PresencePredicate.ABSENT) {
                        if (sn.hc == hc && ct.equal(sn.key, k)) {
                            return Optional.of(sn.value);
                        }
                        return this.insertDual(ct, cn, pos, sn, k, v, hc, lev);
                    }
                    if (cond == PresencePredicate.PRESENT) {
                        if (sn.hc == hc && ct.equal(sn.key, k)) {
                            if (this.GCAS(cn, cn.updatedAt(pos, new SNode<K, V>(k, v, hc), this.gen), ct)) {
                                return Optional.of(sn.value);
                            }
                            return null;
                        }
                        return Optional.empty();
                    }
                    if (sn.hc == hc && ct.equal(sn.key, k) && cond.equals(sn.value)) {
                        if (this.GCAS(cn, cn.updatedAt(pos, new SNode<K, V>(k, v, hc), this.gen), ct)) {
                            return Optional.of(sn.value);
                        }
                        return null;
                    }
                    return Optional.empty();
                }
                throw CNode.invalidElement(cnAtPos);
            }
            if (cond == null || cond == PresencePredicate.ABSENT) {
                CNode<K, V> rn = cn.gen == this.gen ? cn : cn.renewed(this.gen, ct);
                CNode<K, V> ncnode = rn.insertedAt(pos, flag, new SNode<K, V>(k, v, hc), this.gen);
                if (this.GCAS(cn, ncnode, ct)) {
                    return Optional.empty();
                }
                return null;
            }
            return Optional.empty();
        }
        if (m instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return null;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            LNodeEntry entry = ln.get(ct.equiv(), k);
            if (cond == null) {
                if (entry != null) {
                    return this.replaceln(ln, entry, v, ct) ? Optional.of(entry.getValue()) : null;
                }
                return this.insertln(ln, k, v, ct) ? Optional.empty() : null;
            }
            if (cond == PresencePredicate.ABSENT) {
                if (entry != null) {
                    return Optional.of(entry.getValue());
                }
                return this.insertln(ln, k, v, ct) ? Optional.empty() : null;
            }
            if (cond == PresencePredicate.PRESENT) {
                if (entry == null) {
                    return Optional.empty();
                }
                return this.replaceln(ln, entry, v, ct) ? Optional.of(entry.getValue()) : null;
            }
            if (entry == null || !cond.equals(entry.getValue())) {
                return Optional.empty();
            }
            return this.replaceln(ln, entry, v, ct) ? Optional.of(entry.getValue()) : null;
        }
        throw INode.invalidElement(m);
    }

    private boolean insertln(LNode<K, V> ln, K k, V v, TrieMap<K, V> ct) {
        return this.GCAS(ln, ln.insertChild(k, v), ct);
    }

    private boolean replaceln(LNode<K, V> ln, LNodeEntry<K, V> entry, V v, TrieMap<K, V> ct) {
        return this.GCAS(ln, ln.replaceChild(entry, v), ct);
    }

    Object recLookup(K k, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recLookup(k, hc, lev, parent, this.gen, ct);
    }

    private Object recLookup(K k, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m;
        while ((m = this.GCAS_READ(ct)) instanceof CNode) {
            CNode cn = (CNode)m;
            int bmp = cn.bitmap;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            if ((bmp & flag) == 0) {
                return null;
            }
            int pos = bmp == -1 ? idx : Integer.bitCount(bmp & flag - 1);
            BasicNode sub = cn.array[pos];
            if (sub instanceof INode) {
                INode in = (INode)sub;
                if (ct.isReadOnly() || startgen == in.gen) {
                    return in.recLookup(k, hc, lev + 5, this, startgen, ct);
                }
                if (this.GCAS(cn, cn.renewed(startgen, ct), ct)) continue;
                return LookupResult.RESTART;
            }
            if (sub instanceof SNode) {
                SNode sn = (SNode)sub;
                if (sn.hc == hc && ct.equal(sn.key, k)) {
                    return sn.value;
                }
                return null;
            }
            throw CNode.invalidElement(sub);
        }
        if (m instanceof TNode) {
            return this.cleanReadOnly((TNode)m, lev, parent, ct, k, hc);
        }
        if (m instanceof LNode) {
            LNodeEntry entry = ((LNode)m).get(ct.equiv(), k);
            return entry != null ? entry.getValue() : null;
        }
        throw INode.invalidElement(m);
    }

    private Object cleanReadOnly(TNode<K, V> tn, int lev, INode<K, V> parent, TrieMap<K, V> ct, K k, int hc) {
        if (ct.isReadOnly()) {
            if (tn.hc == hc && ct.equal(tn.key, k)) {
                return tn.value;
            }
            return null;
        }
        this.clean(parent, ct, lev - 5);
        return LookupResult.RESTART;
    }

    Optional<V> recRemove(K k, Object cond, int hc, int lev, INode<K, V> parent, TrieMap<K, V> ct) {
        return this.recRemove(k, cond, hc, lev, parent, this.gen, ct);
    }

    @SuppressFBWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Returning null Optional indicates the need to restart.")
    private Optional<V> recRemove(K k, Object cond, int hc, int lev, INode<K, V> parent, Gen startgen, TrieMap<K, V> ct) {
        MainNode<K, V> m = this.GCAS_READ(ct);
        if (m instanceof CNode) {
            MainNode<K, V> n;
            Optional<Object> res;
            CNode cn = (CNode)m;
            int bmp = cn.bitmap;
            int idx = hc >>> lev & 0x1F;
            int flag = 1 << idx;
            if ((bmp & flag) == 0) {
                return Optional.empty();
            }
            int pos = Integer.bitCount(bmp & flag - 1);
            BasicNode sub = cn.array[pos];
            if (sub instanceof INode) {
                INode in = (INode)sub;
                res = startgen == in.gen ? in.recRemove(k, cond, hc, lev + 5, this, startgen, ct) : (this.GCAS(cn, cn.renewed(startgen, ct), ct) ? this.recRemove(k, cond, hc, lev, parent, startgen, ct) : null);
            } else if (sub instanceof SNode) {
                MainNode ncn;
                SNode sn = (SNode)sub;
                res = sn.hc == hc && ct.equal(sn.key, k) && (cond == null || cond.equals(sn.value)) ? (this.GCAS(cn, ncn = cn.removedAt(pos, flag, this.gen).toContracted(lev), ct) ? Optional.of(sn.value) : null) : Optional.empty();
            } else {
                throw CNode.invalidElement(sub);
            }
            if (res == null || !res.isPresent()) {
                return res;
            }
            if (parent != null && (n = this.GCAS_READ(ct)) instanceof TNode) {
                this.cleanParent(n, parent, ct, hc, lev, startgen);
            }
            return res;
        }
        if (m instanceof TNode) {
            this.clean(parent, ct, lev - 5);
            return null;
        }
        if (m instanceof LNode) {
            LNode ln = (LNode)m;
            LNodeEntry entry = ln.get(ct.equiv(), k);
            if (entry == null) {
                return Optional.empty();
            }
            Object value = entry.getValue();
            if (cond != null && !cond.equals(value)) {
                return Optional.empty();
            }
            return this.GCAS(ln, ln.removeChild(entry, hc), ct) ? Optional.of(value) : null;
        }
        throw INode.invalidElement(m);
    }

    private void cleanParent(Object nonlive, INode<K, V> parent, TrieMap<K, V> ct, int hc, int lev, Gen startgen) {
        TNode tn;
        MainNode ncn;
        int flag;
        int bmp;
        int pos;
        CNode cn;
        BasicNode sub;
        do {
            MainNode<K, V> pm;
            if (!((pm = super.GCAS_READ(ct)) instanceof CNode)) {
                return;
            }
            cn = (CNode)pm;
            bmp = cn.bitmap;
            int idx = hc >>> lev - 5 & 0x1F;
            flag = 1 << idx;
            if ((bmp & flag) != 0) continue;
            return;
        } while ((sub = cn.array[pos = Integer.bitCount(bmp & flag - 1)]) == this && nonlive instanceof TNode && !super.GCAS(cn, ncn = cn.updatedAt(pos, (tn = (TNode)nonlive).copyUntombed(), this.gen).toContracted(lev - 5), ct) && ct.readRoot().gen == startgen);
    }

    private void clean(INode<K, V> nd, TrieMap<K, V> ct, int lev) {
        MainNode<K, V> m = super.GCAS_READ(ct);
        if (m instanceof CNode) {
            CNode cn = (CNode)m;
            super.GCAS(cn, cn.toCompressed(ct, lev, this.gen), ct);
        }
    }

    int size(ImmutableTrieMap<?, ?> ct) {
        return this.GCAS_READ(ct).size(ct);
    }
}

