/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.opendaylight.yangtools.triemap.AbstractIterator;
import org.opendaylight.yangtools.triemap.EntryUtil;
import org.opendaylight.yangtools.triemap.MutableTrieMap;

final class MutableIterator<K, V>
extends AbstractIterator<K, V> {
    private final MutableTrieMap<K, V> mutable;
    private Map.Entry<K, V> lastReturned;

    MutableIterator(MutableTrieMap<K, V> map) {
        super(map.immutableSnapshot());
        this.mutable = map;
    }

    @Override
    public void remove() {
        Preconditions.checkState(this.lastReturned != null);
        this.mutable.remove(this.lastReturned.getKey());
        this.lastReturned = null;
    }

    @Override
    Map.Entry<K, V> wrapEntry(Map.Entry<K, V> entry) {
        this.lastReturned = entry;
        return new MutableEntry<K, V>(this.mutable, entry);
    }

    private static final class MutableEntry<K, V>
    implements Map.Entry<K, V> {
        private final MutableTrieMap<K, V> map;
        private final Map.Entry<K, V> delegate;
        private V newValue = null;

        MutableEntry(MutableTrieMap<K, V> map, Map.Entry<K, V> delegate) {
            this.map = map;
            this.delegate = delegate;
        }

        @Override
        public K getKey() {
            return this.delegate.getKey();
        }

        @Override
        public V getValue() {
            return this.newValue != null ? this.newValue : this.delegate.getValue();
        }

        @Override
        public V setValue(V value) {
            V ret = this.getValue();
            this.map.put(this.getKey(), value);
            this.newValue = value;
            return ret;
        }

        @Override
        public int hashCode() {
            return EntryUtil.hash(this.getKey(), this.getValue());
        }

        @Override
        @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality handled by utility methods")
        public boolean equals(Object obj) {
            return EntryUtil.equal(obj, this.getKey(), this.getValue());
        }

        public String toString() {
            return EntryUtil.string(this.getKey(), this.getValue());
        }
    }
}

