/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

final class ConstantArrayCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final E[] array;

    ConstantArrayCollection(E[] array) {
        this.array = Objects.requireNonNull(array);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (E wlk : this.array) {
            if (!o.equals(wlk)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Iterator<E> iterator() {
        return new UnmodifiableIterator<E>(){
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < ConstantArrayCollection.this.array.length;
            }

            @Override
            public E next() {
                if (this.offset >= ConstantArrayCollection.this.array.length) {
                    throw new NoSuchElementException();
                }
                return ConstantArrayCollection.this.array[this.offset++];
            }
        };
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return (Object[])this.array.clone();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        if (a.length < this.array.length) {
            return Arrays.copyOf(this.array, this.array.length, a.getClass().getComponentType());
        }
        System.arraycopy(this.array, 0, a, 0, this.array.length);
        if (a.length > this.array.length) {
            a[this.array.length] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (E e : this.array) {
            result = 31 * result + e.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConstantArrayCollection)) {
            return false;
        }
        return Arrays.equals(this.array, ((ConstantArrayCollection)obj).array);
    }

    public String toString() {
        if (this.array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        int offset = 0;
        while (offset < this.array.length - 1) {
            sb.append(String.valueOf(this.array[offset++])).append(", ");
        }
        return sb.append(String.valueOf(this.array[offset])).append(']').toString();
    }
}

