/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.MutableOffsetMap;
import org.opendaylight.yangtools.util.SingletonSet;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

@Beta
public abstract class SharedSingletonMap<K, V>
implements Serializable,
UnmodifiableMapPhase<K, V> {
    private static final long serialVersionUID = 1L;
    private static final LoadingCache<Object, SingletonSet<Object>> CACHE = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<Object, SingletonSet<Object>>(){

        @Override
        public SingletonSet<Object> load(@Nonnull Object key) {
            return SingletonSet.of(key);
        }
    });
    private final SingletonSet<K> keySet;
    private final V value;
    private int hashCode;

    SharedSingletonMap(K key, V value) {
        this.keySet = CACHE.getUnchecked(key);
        this.value = Objects.requireNonNull(value);
    }

    public static <K, V> SharedSingletonMap<K, V> orderedOf(K key, V value) {
        return new Ordered<K, V>(key, value);
    }

    public static <K, V> SharedSingletonMap<K, V> unorderedOf(K key, V value) {
        return new Unordered<K, V>(key, value);
    }

    public static <K, V> SharedSingletonMap<K, V> orderedCopyOf(Map<K, V> map) {
        Preconditions.checkArgument(map.size() == 1);
        Map.Entry<K, V> e = map.entrySet().iterator().next();
        return new Ordered<K, V>(e.getKey(), e.getValue());
    }

    public static <K, V> SharedSingletonMap<K, V> unorderedCopyOf(Map<K, V> map) {
        Preconditions.checkArgument(map.size() == 1);
        Map.Entry<K, V> e = map.entrySet().iterator().next();
        return new Unordered<K, V>(e.getKey(), e.getValue());
    }

    @Override
    @Nonnull
    public final SingletonSet<Map.Entry<K, V>> entrySet() {
        return SingletonSet.of(new AbstractMap.SimpleImmutableEntry<K, V>(this.keySet.getElement(), this.value));
    }

    @Override
    @Nonnull
    public final SingletonSet<K> keySet() {
        return this.keySet;
    }

    @Override
    @Nonnull
    public final SingletonSet<V> values() {
        return SingletonSet.of(this.value);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.keySet.contains(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.value.equals(value);
    }

    @Override
    public final V get(Object key) {
        return this.keySet.contains(key) ? (V)this.value : null;
    }

    @Override
    public final int size() {
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.keySet.getElement().hashCode() ^ this.value.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        return m.size() == 1 && this.value.equals(m.get(this.keySet.getElement()));
    }

    public final String toString() {
        return "{" + this.keySet.getElement() + '=' + this.value + '}';
    }

    private static final class Unordered<K, V>
    extends SharedSingletonMap<K, V> {
        private static final long serialVersionUID = 1L;

        Unordered(K key, V value) {
            super(key, value);
        }

        @Override
        @Nonnull
        public ModifiableMapPhase<K, V> toModifiableMap() {
            return MutableOffsetMap.unorderedCopyOf(this);
        }
    }

    private static final class Ordered<K, V>
    extends SharedSingletonMap<K, V> {
        private static final long serialVersionUID = 1L;

        Ordered(K key, V value) {
            super(key, value);
        }

        @Override
        @Nonnull
        public ModifiableMapPhase<K, V> toModifiableMap() {
            return MutableOffsetMap.orderedCopyOf(this);
        }
    }
}

