/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.annotations.Beta;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nonnull;

public class TrackingLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private static final AtomicIntegerFieldUpdater<TrackingLinkedBlockingQueue> LARGEST_QUEUE_SIZE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(TrackingLinkedBlockingQueue.class, "largestQueueSize");
    private volatile int largestQueueSize = 0;

    public TrackingLinkedBlockingQueue() {
    }

    public TrackingLinkedBlockingQueue(Collection<? extends E> c) {
        super(c);
    }

    public TrackingLinkedBlockingQueue(int capacity) {
        super(capacity);
    }

    @Beta
    public long getLargestQueueSize() {
        return this.largestQueueSize;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (super.offer(e, timeout, unit)) {
            this.updateLargestQueueSize();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(@Nonnull E e) {
        if (super.offer(e)) {
            this.updateLargestQueueSize();
            return true;
        }
        return false;
    }

    @Override
    public void put(E e) throws InterruptedException {
        super.put(e);
        this.updateLargestQueueSize();
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.updateLargestQueueSize();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        try {
            boolean bl = super.addAll(c);
            return bl;
        }
        finally {
            this.updateLargestQueueSize();
        }
    }

    private void updateLargestQueueSize() {
        int largest;
        int size = this.size();
        while (size > (largest = this.largestQueueSize) && !LARGEST_QUEUE_SIZE_UPDATER.weakCompareAndSet(this, largest, size)) {
        }
    }
}

