/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;

public final class BindingMapping {
    public static final String VERSION = "0.6";
    public static final Set<String> JAVA_RESERVED_WORDS = ImmutableSet.of("abstract", "assert", "boolean", "break", "byte", "case", new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "false", "true", "null"});
    public static final String DATA_ROOT_SUFFIX = "Data";
    public static final String RPC_SERVICE_SUFFIX = "Service";
    public static final String NOTIFICATION_LISTENER_SUFFIX = "Listener";
    public static final String QNAME_STATIC_FIELD_NAME = "QNAME";
    public static final String PACKAGE_PREFIX = "org.opendaylight.yang.gen.v1";
    public static final String AUGMENTATION_FIELD = "augmentation";
    private static final Splitter CAMEL_SPLITTER = Splitter.on(CharMatcher.anyOf(" _.-/").precomputed()).omitEmptyStrings().trimResults();
    private static final Pattern COLON_SLASH_SLASH = Pattern.compile("://", 16);
    private static final String QUOTED_DOT = Matcher.quoteReplacement(".");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    public static final String MODULE_INFO_CLASS_NAME = "$YangModuleInfoImpl";
    public static final String MODEL_BINDING_PROVIDER_CLASS_NAME = "$YangModelBindingProvider";
    public static final String RPC_INPUT_SUFFIX = "Input";
    public static final String RPC_OUTPUT_SUFFIX = "Output";
    private static final String NEGATED_PATTERN_PREFIX = "^(?!";
    private static final String NEGATED_PATTERN_SUFFIX = ").*$";
    private static final Interner<String> PACKAGE_INTERNER = Interners.newWeakInterner();

    private BindingMapping() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static String getRootPackageName(QName module) {
        return BindingMapping.getRootPackageName(module.getModule());
    }

    public static String getRootPackageName(QNameModule module) {
        Optional<Revision> optRev;
        Preconditions.checkArgument(module != null, "Module must not be null");
        Preconditions.checkArgument(module.getRevision() != null, "Revision must not be null");
        Preconditions.checkArgument(module.getNamespace() != null, "Namespace must not be null");
        StringBuilder packageNameBuilder = new StringBuilder();
        packageNameBuilder.append(PACKAGE_PREFIX);
        packageNameBuilder.append('.');
        String namespace = module.getNamespace().toString();
        namespace = COLON_SLASH_SLASH.matcher(namespace).replaceAll(QUOTED_DOT);
        char[] chars = namespace.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': 
                case '$': 
                case '\'': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': {
                    chars[i] = 46;
                    continue block3;
                }
            }
        }
        packageNameBuilder.append(chars);
        if (chars[chars.length - 1] != '.') {
            packageNameBuilder.append('.');
        }
        if ((optRev = module.getRevision()).isPresent()) {
            String rev = optRev.get().toString();
            Preconditions.checkArgument(rev.length() == 10, "Unsupported revision %s", (Object)rev);
            packageNameBuilder.append("rev");
            packageNameBuilder.append(rev.substring(2, 4)).append(rev.substring(5, 7)).append(rev.substring(8));
        } else {
            packageNameBuilder.append("norev");
        }
        return BindingMapping.normalizePackageName(packageNameBuilder.toString());
    }

    public static String normalizePackageName(String packageName) {
        if (packageName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String p : DOT_SPLITTER.split(packageName.toLowerCase())) {
            if (first) {
                first = false;
            } else {
                builder.append('.');
            }
            if (Character.isDigit(p.charAt(0)) || JAVA_RESERVED_WORDS.contains(p)) {
                builder.append('_');
            }
            builder.append(p);
        }
        return PACKAGE_INTERNER.intern(builder.toString());
    }

    public static String getClassName(String localName) {
        Preconditions.checkArgument(localName != null, "Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(localName));
    }

    public static String getClassName(QName name) {
        Preconditions.checkArgument(name != null, "Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
    }

    public static String getMethodName(String yangIdentifier) {
        Preconditions.checkArgument(yangIdentifier != null, "Identifier should not be null");
        return BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
    }

    public static String getMethodName(QName name) {
        Preconditions.checkArgument(name != null, "Name should not be null.");
        return BindingMapping.getMethodName(name.getLocalName());
    }

    public static String getGetterSuffix(QName name) {
        Preconditions.checkArgument(name != null, "Name should not be null.");
        String candidate = BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
        return "Class".equals(candidate) ? "XmlClass" : candidate;
    }

    public static String getPropertyName(String yangIdentifier) {
        String potential = BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
        if ("class".equals(potential)) {
            return "xmlClass";
        }
        return potential;
    }

    private static String toCamelCase(String rawString) {
        Preconditions.checkArgument(rawString != null, "String should not be null");
        Iterable<String> components = CAMEL_SPLITTER.split(rawString);
        StringBuilder builder = new StringBuilder();
        for (String comp : components) {
            builder.append(BindingMapping.toFirstUpper(comp));
        }
        return BindingMapping.checkNumericPrefix(builder.toString());
    }

    private static String checkNumericPrefix(String rawString) {
        if (rawString == null || rawString.isEmpty()) {
            return rawString;
        }
        char firstChar = rawString.charAt(0);
        if (firstChar >= '0' && firstChar <= '9') {
            return "_" + rawString;
        }
        return rawString;
    }

    public static String negatePatternString(String pattern) {
        Preconditions.checkArgument(pattern.charAt(0) == '^' && pattern.charAt(pattern.length() - 1) == '$', "Pattern '%s' does not have expected format", (Object)pattern);
        boolean hasGroup = pattern.startsWith("^(?:") && pattern.endsWith(")$");
        int len = pattern.length();
        StringBuilder sb = new StringBuilder(len + (hasGroup ? 7 : 11)).append(NEGATED_PATTERN_PREFIX);
        if (hasGroup) {
            sb.append(pattern, 1, len);
        } else {
            sb.append("(?:").append(pattern, 1, len - 1).append(")$");
        }
        return sb.append(NEGATED_PATTERN_SUFFIX).toString();
    }

    public static boolean isNegatedPattern(Pattern pattern) {
        return BindingMapping.isNegatedPattern(pattern.toString());
    }

    private static boolean isNegatedPattern(String pattern) {
        return pattern.startsWith(NEGATED_PATTERN_PREFIX) && pattern.endsWith(NEGATED_PATTERN_SUFFIX);
    }

    public static String toFirstUpper(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String toFirstLower(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static BiMap<String, String> mapEnumAssignedNames(Collection<String> assignedNames) {
        HashBiMap<String, String> javaToYang = HashBiMap.create(assignedNames.size());
        boolean valid = true;
        for (String name : assignedNames) {
            String mappedName;
            Preconditions.checkArgument(!name.isEmpty());
            if (javaToYang.containsValue(name) || BindingMapping.isValidJavaIdentifier(mappedName = BindingMapping.getClassName(name)) && javaToYang.forcePut(mappedName, name) == null) continue;
            valid = false;
            break;
        }
        if (!valid) {
            javaToYang.clear();
            for (String name : assignedNames) {
                javaToYang.put(BindingMapping.mapEnumAssignedName(name), name);
            }
        }
        return javaToYang.inverse();
    }

    private static boolean isValidJavaIdentifier(String str) {
        return !str.isEmpty() && !JAVA_RESERVED_WORDS.contains(str) && Character.isJavaIdentifierStart(str.codePointAt(0)) && str.codePoints().skip(1L).allMatch(Character::isJavaIdentifierPart);
    }

    private static String mapEnumAssignedName(String assignedName) {
        Preconditions.checkArgument(!assignedName.isEmpty());
        if (assignedName.indexOf(36) == -1 && BindingMapping.isValidJavaIdentifier(assignedName)) {
            return assignedName;
        }
        StringBuilder sb = new StringBuilder().append('$');
        assignedName.codePoints().forEachOrdered(codePoint -> {
            if (codePoint == 36 || !Character.isJavaIdentifierPart(codePoint)) {
                sb.append('$').append(Integer.toHexString(codePoint).toUpperCase(Locale.ROOT)).append('$');
            } else {
                sb.appendCodePoint(codePoint);
            }
        });
        return sb.toString();
    }
}

