/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.binding.util.RpcMethodInvoker;
import org.opendaylight.yangtools.yang.binding.util.RpcServiceInvoker;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMappedRpcInvoker<T>
extends RpcServiceInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMappedRpcInvoker.class);
    private final Map<T, RpcMethodInvoker> map;

    protected AbstractMappedRpcInvoker(Map<T, Method> map) {
        ImmutableMap.Builder<T, RpcMethodInvoker> b = ImmutableMap.builder();
        for (Map.Entry<T, Method> e : map.entrySet()) {
            if (BindingReflections.isRpcMethod(e.getValue())) {
                b.put(e.getKey(), RpcMethodInvoker.from(e.getValue()));
                continue;
            }
            LOG.debug("Method {} is not an RPC method, ignoring it", (Object)e.getValue());
        }
        this.map = b.build();
    }

    protected abstract T qnameToKey(QName var1);

    @Override
    public final Future<RpcResult<?>> invokeRpc(@Nonnull RpcService impl, @Nonnull QName rpcName, @Nullable DataObject input) {
        Preconditions.checkNotNull(impl, "Implementation must be supplied");
        RpcMethodInvoker invoker = this.map.get(this.qnameToKey(rpcName));
        Preconditions.checkArgument(invoker != null, "Supplied RPC is not valid for implementation %s", (Object)impl);
        return invoker.invokeOn(impl, input);
    }
}

