/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.util.AbstractMappedRpcInvoker;
import org.opendaylight.yangtools.yang.binding.util.RpcServiceInvoker;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;

final class LocalNameRpcServiceInvoker
extends AbstractMappedRpcInvoker<String> {
    private final QNameModule module;

    private LocalNameRpcServiceInvoker(QNameModule module, Map<String, Method> map) {
        super(map);
        this.module = Preconditions.checkNotNull(module);
    }

    static RpcServiceInvoker instanceFor(QNameModule module, Map<QName, Method> qnameToMethod) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Map.Entry<QName, Method> e : qnameToMethod.entrySet()) {
            map.put(e.getKey().getLocalName(), e.getValue());
        }
        return new LocalNameRpcServiceInvoker(module, map);
    }

    @Override
    protected String qnameToKey(QName qname) {
        if (this.module.equals(qname.getModule())) {
            return qname.getLocalName();
        }
        return null;
    }
}

