/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;

public final class NotificationListenerInvoker {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final LoadingCache<Class<? extends NotificationListener>, NotificationListenerInvoker> INVOKERS = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<? extends NotificationListener>, NotificationListenerInvoker>(){

        private NotificationListenerInvoker createInvoker(Class<? extends NotificationListener> key) {
            return new NotificationListenerInvoker(this.createInvokerMap(key));
        }

        private Map<QName, MethodHandle> createInvokerMap(Class<? extends NotificationListener> key) {
            ImmutableMap.Builder<QName, MethodHandle> ret = ImmutableMap.builder();
            for (Method method : key.getMethods()) {
                if (!BindingReflections.isNotificationCallback(method)) continue;
                Class<?> notification = method.getParameterTypes()[0];
                QName name = BindingReflections.findQName(notification);
                try {
                    MethodHandle handle = LOOKUP.unreflect(method).asType(MethodType.methodType(Void.TYPE, NotificationListener.class, DataContainer.class));
                    ret.put(name, handle);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Can not access public method.", e);
                }
            }
            return ret.build();
        }

        @Override
        public NotificationListenerInvoker load(Class<? extends NotificationListener> key) {
            return this.createInvoker(key);
        }
    });
    private final Map<QName, MethodHandle> methodInvokers;

    public NotificationListenerInvoker(Map<QName, MethodHandle> map) {
        this.methodInvokers = map;
    }

    public static NotificationListenerInvoker from(Class<? extends NotificationListener> type) {
        Preconditions.checkArgument(type.isInterface());
        Preconditions.checkArgument(BindingReflections.isBindingClass(type));
        return INVOKERS.getUnchecked(type);
    }

    public void invokeNotification(@Nonnull NotificationListener impl, @Nonnull QName rpcName, @Nullable DataContainer input) {
        Preconditions.checkNotNull(impl, "implemetation must be supplied");
        MethodHandle invoker = this.methodInvokers.get(rpcName);
        Preconditions.checkArgument(invoker != null, "Supplied notification is not valid for implementation %s", (Object)impl);
        try {
            invoker.invokeExact(impl, input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

