/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.ClassBasedRpcServiceInvoker;
import org.opendaylight.yangtools.yang.binding.util.LocalNameRpcServiceInvoker;
import org.opendaylight.yangtools.yang.binding.util.QNameRpcServiceInvoker;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcServiceInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(RpcServiceInvoker.class);

    public static RpcServiceInvoker from(Class<? extends RpcService> type) {
        return ClassBasedRpcServiceInvoker.instanceFor(type);
    }

    public static RpcServiceInvoker from(Map<QName, Method> qnameToMethod) {
        Preconditions.checkArgument(!qnameToMethod.isEmpty());
        QNameModule module = null;
        for (QName qname : qnameToMethod.keySet()) {
            if (module != null) {
                if (module.equals(qname.getModule())) continue;
                LOG.debug("QNames from different modules {} and {}, falling back to QName map", (Object)module, (Object)qname.getModule());
                return QNameRpcServiceInvoker.instanceFor(qnameToMethod);
            }
            module = qname.getModule();
        }
        return LocalNameRpcServiceInvoker.instanceFor(module, qnameToMethod);
    }

    public abstract Future<RpcResult<?>> invokeRpc(@Nonnull RpcService var1, @Nonnull QName var2, @Nullable DataObject var3);
}

