/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.UnsignedInteger;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
public final class Uint32
extends Number
implements Comparable<Uint32>,
Immutable {
    private static final long serialVersionUID = 1L;
    private static final long MIN_VALUE = 0L;
    private static final long MAX_VALUE = 0xFFFFFFFFL;
    private static final Uint32[] CACHE = new Uint32[255];
    private static final Uint32[] COMMON = new Uint32[]{new Uint32(Short.MAX_VALUE), new Uint32(32768), new Uint32(65535), new Uint32(65536), new Uint32(Integer.MAX_VALUE)};
    private static final int DEFAULT_LRU_SIZE = 1024;
    private static final String LRU_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint32.LRU.size";
    private static final int MAX_LRU_SIZE = 0xFFFFFF;
    private static final int LRU_SIZE;
    private static final LoadingCache<Integer, Uint32> LRU;
    private final int value;

    @VisibleForTesting
    Uint32(int value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint32 instanceFor(int value) {
        long longSlot = Integer.toUnsignedLong(value);
        if (longSlot >= (long)CACHE.length) {
            for (Uint32 c : COMMON) {
                if (c.value != value) continue;
                return c;
            }
            return LRU.getUnchecked(value);
        }
        int slot = (int)longSlot;
        Uint32 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint32[] uint32Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint32.CACHE[slot] = ret = new Uint32(value);
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint32 fromIntBits(int bits) {
        return Uint32.instanceFor(bits);
    }

    public static Uint32 fromUnsignedInteger(UnsignedInteger uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(byte byteVal) {
        Preconditions.checkArgument((long)byteVal >= 0L, "Negative values are not allowed");
        return Uint32.instanceFor(byteVal);
    }

    public static Uint32 valueOf(short shortVal) {
        Preconditions.checkArgument((long)shortVal >= 0L, "Negative values are not allowed");
        return Uint32.instanceFor(shortVal);
    }

    public static Uint32 valueOf(int intVal) {
        Preconditions.checkArgument((long)intVal >= 0L, "Value %s is outside of allowed range", intVal);
        return Uint32.instanceFor(intVal);
    }

    public static Uint32 valueOf(long longVal) {
        Preconditions.checkArgument(longVal >= 0L && longVal <= 0xFFFFFFFFL, "Value %s is outside of allowed range", longVal);
        return Uint32.instanceFor((int)longVal);
    }

    public static Uint32 valueOf(Uint8 uint) {
        return Uint32.instanceFor(uint.shortValue());
    }

    public static Uint32 valueOf(Uint16 uint) {
        return Uint32.instanceFor(uint.intValue());
    }

    public static Uint32 valueOf(Uint64 uint) {
        return Uint32.valueOf(uint.longValue());
    }

    public static Uint32 valueOf(String string) {
        return Uint32.valueOf(string, 10);
    }

    public static Uint32 valueOf(String string, int radix) {
        return Uint32.instanceFor(Integer.parseUnsignedInt(string, radix));
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.value);
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public UnsignedInteger toUnsignedInteger() {
        return UnsignedInteger.fromIntBits(this.value);
    }

    @Override
    public int compareTo(Uint32 o) {
        return Integer.compareUnsigned(this.value, o.value);
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Uint32 && this.value == ((Uint32)obj).value;
    }

    public String toString() {
        return Integer.toUnsignedString(this.value);
    }

    private Object readResolve() {
        return Uint32.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(LRU_SIZE_PROPERTY, 1024);
        LRU_SIZE = p >= 0 ? Math.min(p, 0xFFFFFF) : 1024;
        LRU = CacheBuilder.newBuilder().weakValues().maximumSize(LRU_SIZE).build(new CacheLoader<Integer, Uint32>(){

            @Override
            public Uint32 load(Integer key) {
                return new Uint32(key);
            }
        });
    }
}

