/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
public final class Uint64
extends Number
implements Comparable<Uint64>,
Immutable {
    private static final long serialVersionUID = 1L;
    private static final long MIN_VALUE = 0L;
    private static final Uint64[] CACHE = new Uint64[255];
    private static final Uint64[] COMMON = new Uint64[]{new Uint64(32768L), new Uint64(32768L), new Uint64(65535L), new Uint64(65536L), new Uint64(Integer.MAX_VALUE), new Uint64(0x80000000L), new Uint64(Long.MAX_VALUE)};
    private static final int DEFAULT_LRU_SIZE = 1024;
    private static final String LRU_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint64.LRU.size";
    private static final int MAX_LRU_SIZE = 0xFFFFFF;
    private static final int LRU_SIZE;
    private static final LoadingCache<Long, Uint64> LRU;
    private final long value;

    @VisibleForTesting
    Uint64(long value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint64 instanceFor(long value) {
        int slot = (int)value;
        if (slot < 0 || slot >= CACHE.length) {
            for (Uint64 c : COMMON) {
                if (c.value != value) continue;
                return c;
            }
            return LRU.getUnchecked(value);
        }
        Uint64 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint64[] uint64Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint64.CACHE[slot] = ret = new Uint64(value);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint64 fromLongBits(long bits) {
        return Uint64.instanceFor(bits);
    }

    public static Uint64 fromUnsignedLong(UnsignedLong ulong) {
        return Uint64.instanceFor(ulong.longValue());
    }

    public static Uint64 valueOf(byte byteVal) {
        Preconditions.checkArgument((long)byteVal >= 0L, "Negative values are not allowed");
        return Uint64.instanceFor(byteVal);
    }

    public static Uint64 valueOf(short shortVal) {
        Preconditions.checkArgument((long)shortVal >= 0L, "Negative values are not allowed");
        return Uint64.instanceFor(shortVal);
    }

    public static Uint64 valueOf(int intVal) {
        Preconditions.checkArgument((long)intVal >= 0L, "Value %s is outside of allowed range", intVal);
        return Uint64.instanceFor(intVal);
    }

    public static Uint64 valueOf(long longVal) {
        Preconditions.checkArgument(longVal >= 0L, "Value %s is outside of allowed range", longVal);
        return Uint64.instanceFor(longVal);
    }

    public static Uint64 valueOf(Uint8 uint) {
        return Uint64.instanceFor(uint.shortValue());
    }

    public static Uint64 valueOf(Uint16 uint) {
        return Uint64.instanceFor(uint.intValue());
    }

    public static Uint64 valueOf(Uint32 uint) {
        return Uint64.instanceFor(uint.longValue());
    }

    public static Uint64 valueOf(String string) {
        return Uint64.valueOf(string, 10);
    }

    public static Uint64 valueOf(String string, int radix) {
        return Uint64.instanceFor(Long.parseUnsignedLong(string, radix));
    }

    public static Uint64 valueOf(BigInteger bigInt) {
        Preconditions.checkArgument(bigInt.signum() >= 0, "Negative values not allowed");
        Preconditions.checkArgument(bigInt.bitLength() <= 64, "Value %s is outside of allowed range", (Object)bigInt);
        return Uint64.instanceFor(bigInt.longValue());
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return UnsignedLong.fromLongBits(this.value).floatValue();
    }

    @Override
    public double doubleValue() {
        return UnsignedLong.fromLongBits(this.value).doubleValue();
    }

    public UnsignedLong toUnsignedLong() {
        return UnsignedLong.fromLongBits(this.value);
    }

    @Override
    public int compareTo(Uint64 o) {
        return Long.compareUnsigned(this.value, o.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Uint64 && this.value == ((Uint64)obj).value;
    }

    public String toString() {
        return Long.toUnsignedString(this.value);
    }

    private Object readResolve() {
        return Uint64.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(LRU_SIZE_PROPERTY, 1024);
        LRU_SIZE = p >= 0 ? Math.min(p, 0xFFFFFF) : 1024;
        LRU = CacheBuilder.newBuilder().weakValues().maximumSize(LRU_SIZE).build(new CacheLoader<Long, Uint64>(){

            @Override
            public Uint64 load(Long key) {
                return new Uint64(key);
            }
        });
    }
}

