/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.meta;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@Beta
@NonNullByDefault
@ThreadSafe
public final class DefaultStatementDefinition<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
implements StatementDefinition {
    private final Class<E> effectiveRepresentation;
    private final Class<D> declaredRepresentation;
    private final QName statementName;
    private final @Nullable QName argumentName;
    private final boolean argumentYinElement;

    DefaultStatementDefinition(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, boolean argumentYinElement, @Nullable QName argumentName) {
        this.statementName = Objects.requireNonNull(statementName);
        this.declaredRepresentation = Objects.requireNonNull(declaredRepresentation);
        this.effectiveRepresentation = Objects.requireNonNull(effectiveRepresentation);
        this.argumentYinElement = argumentYinElement;
        this.argumentName = argumentName;
        Preconditions.checkArgument(declaredRepresentation.isInterface(), "Declared representation %s is not an interface", declaredRepresentation);
        Preconditions.checkArgument(effectiveRepresentation.isInterface(), "Effective representation %s is not an interface", effectiveRepresentation);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation) {
        return new DefaultStatementDefinition<A, D, E>(statementName, declaredRepresentation, effectiveRepresentation, false, null);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, QName argumentName) {
        return DefaultStatementDefinition.of(statementName, declaredRepresentation, effectiveRepresentation, argumentName, false);
    }

    public static <A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>> DefaultStatementDefinition<A, D, E> of(QName statementName, Class<D> declaredRepresentation, Class<E> effectiveRepresentation, QName argumentName, boolean argumentYinElement) {
        return new DefaultStatementDefinition<A, D, E>(statementName, declaredRepresentation, effectiveRepresentation, argumentYinElement, Objects.requireNonNull(argumentName));
    }

    @Override
    public QName getStatementName() {
        return this.statementName;
    }

    @Override
    public @Nullable QName getArgumentName() {
        return this.argumentName;
    }

    @Override
    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.declaredRepresentation;
    }

    @Override
    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveRepresentation;
    }

    @Override
    public boolean isArgumentYinElement() {
        return this.argumentYinElement;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("name", this.statementName).add("declared", this.declaredRepresentation).add("effective", this.effectiveRepresentation);
        if (this.argumentName != null) {
            helper.add("argument", this.argumentName).add("yin-element", this.argumentYinElement);
        }
        return helper.toString();
    }
}

