/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

@Beta
public final class RevisionSourceIdentifier
extends SourceIdentifier {
    private static final long serialVersionUID = 1L;

    RevisionSourceIdentifier(String name) {
        super(name);
    }

    RevisionSourceIdentifier(String name, @Nullable Revision revision) {
        super(Objects.requireNonNull(name), revision);
    }

    private RevisionSourceIdentifier(String name, Optional<Revision> revision) {
        super(name, revision);
    }

    public static RevisionSourceIdentifier create(String moduleName, Optional<Revision> revision) {
        return new RevisionSourceIdentifier(moduleName, revision);
    }

    public static RevisionSourceIdentifier create(String moduleName, @Nullable Revision revision) {
        return new RevisionSourceIdentifier(moduleName, revision);
    }

    public static RevisionSourceIdentifier create(String moduleName) {
        return new RevisionSourceIdentifier(moduleName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.getRevision());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RevisionSourceIdentifier)) {
            return false;
        }
        RevisionSourceIdentifier other = (RevisionSourceIdentifier)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getRevision(), other.getRevision());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RevisionSourceIdentifier [name=");
        sb.append(this.getName());
        Optional<Revision> rev = this.getRevision();
        if (rev.isPresent()) {
            sb.append('@').append(rev.get());
        }
        return sb.append(']').toString();
    }
}

