/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;

@Beta
public class SchemaResolutionException
extends SchemaSourceException {
    private static final long serialVersionUID = 1L;
    private final SourceIdentifier failedSource;
    private final Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports;
    private final Collection<SourceIdentifier> resolvedSources;

    public SchemaResolutionException(@Nonnull String message) {
        this(message, null);
    }

    public SchemaResolutionException(@Nonnull String message, Throwable cause) {
        this(message, null, cause, Collections.emptySet(), ImmutableMultimap.of());
    }

    public SchemaResolutionException(@Nonnull String message, SourceIdentifier failedSource, Throwable cause) {
        this(message, failedSource, cause, Collections.emptySet(), ImmutableMultimap.of());
    }

    public SchemaResolutionException(@Nonnull String message, Collection<SourceIdentifier> resolvedSources, @Nonnull Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports) {
        this(message, null, null, resolvedSources, unsatisfiedImports);
    }

    public SchemaResolutionException(@Nonnull String message, SourceIdentifier failedSource, Throwable cause, @Nonnull Collection<SourceIdentifier> resolvedSources, @Nonnull Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports) {
        super(SchemaResolutionException.formatMessage(message, failedSource, resolvedSources, unsatisfiedImports), cause);
        this.failedSource = failedSource;
        this.unsatisfiedImports = ImmutableMultimap.copyOf(unsatisfiedImports);
        this.resolvedSources = ImmutableList.copyOf(resolvedSources);
    }

    private static String formatMessage(String message, SourceIdentifier failedSource, Collection<SourceIdentifier> resolvedSources, Multimap<SourceIdentifier, ModuleImport> unsatisfiedImports) {
        return String.format("%s, failed source: %s, resolved sources: %s, unsatisfied imports: %s", message, failedSource, resolvedSources, unsatisfiedImports);
    }

    public final SourceIdentifier getFailedSource() {
        return this.failedSource;
    }

    public final Multimap<SourceIdentifier, ModuleImport> getUnsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    public final Collection<SourceIdentifier> getResolvedSources() {
        return this.resolvedSources;
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("unsatisfiedImports", this.unsatisfiedImports)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }
}

